/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.IQtInstall;

public class QtInstall
implements IQtInstall {
    private final Path qmakePath;
    private String spec;
    private Map<String, String> properties = new HashMap<String, String>();

    public QtInstall(Path qmakePath) {
        this.qmakePath = qmakePath;
    }

    @Override
    public Path getQmakePath() {
        return this.qmakePath;
    }

    @Override
    public Path getLibPath() {
        return this.qmakePath.resolve("../lib");
    }

    @Override
    public Path getQmlPath() {
        return this.qmakePath.resolve("../../qml");
    }

    public static String getSpec(Path qmakePath) throws IOException {
        if (Files.exists(qmakePath, new LinkOption[0])) {
            Process proc = new ProcessBuilder(qmakePath.toString(), "-query", "QMAKE_XSPEC").start();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line = reader.readLine();
                if (line != null) {
                    return line.trim();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public String getSpec() {
        if (this.spec == null) {
            try {
                this.spec = QtInstall.getSpec(this.getQmakePath());
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return this.spec;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

