/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPAbstractPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPMemoryByte;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.Rendering;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class FPDataPane
extends FPAbstractPane {
    public FPDataPane(Rendering parent) {
        super(parent);
    }

    protected String bytesToSciNotation(FPMemoryByte[] bytes) {
        return this.fRendering.sciNotationString(bytes, this.fRendering.getFPDataType(), this.fRendering.isDisplayLittleEndian());
    }

    @Override
    protected void editCell(BigInteger cellAddress, int subCellPosition, char character) {
        try {
            if (!this.fRendering.isEditingCell()) {
                BigInteger vpStart = this.fRendering.getViewportStartAddress();
                BigInteger colChars = BigInteger.valueOf(this.fRendering.getCharsPerColumn());
                BigInteger dtBytes = BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength());
                BigInteger memoryAddress = vpStart.add(cellAddress.subtract(vpStart).divide(colChars).multiply(dtBytes));
                if (!this.fRendering.insertMode()) {
                    this.fRendering.startCellEditing(cellAddress, memoryAddress, this.bytesToSciNotation(this.fRendering.getBytes(cellAddress, this.fRendering.getFPDataType().getByteLength())));
                } else {
                    this.fRendering.startCellEditing(cellAddress, memoryAddress, FPutilities.fillString(this.fRendering.getCharsPerColumn(), ' '));
                    subCellPosition = 0;
                    Point cellCoordinates = this.getCellLocation(cellAddress);
                    this.positionCaret(cellCoordinates.x, cellCoordinates.y);
                    this.fCaret.setVisible(true);
                }
            }
            String cellString = this.fRendering.getEditBuffer().toString().toLowerCase();
            if (character == '.' && FPutilities.countMatches(cellString, ".") > 0 && cellString.indexOf(46) != subCellPosition || character == 'e' && FPutilities.countMatches(cellString, "e") > 0 && cellString.indexOf(101) != subCellPosition) {
                return;
            }
            if (character == '+' && FPutilities.countMatches(cellString, "+") > 1 || character == '-' && FPutilities.countMatches(cellString, "-") > 1) {
                return;
            }
            if (subCellPosition < this.fRendering.getEditBuffer().length()) {
                this.fRendering.getEditBuffer().setCharAt(subCellPosition, character);
            }
            if (subCellPosition < this.fRendering.getCharsPerColumn()) {
                this.advanceCursor();
            }
            this.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected int getCellWidth() {
        return this.getCellCharacterCount() * this.getCellCharacterWidth() + this.fRendering.getCellPadding() * 2;
    }

    @Override
    protected int getCellCharacterCount() {
        return this.fRendering.getCharsPerColumn();
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.fRendering.getColumnCount() * this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col >= this.fRendering.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getFPDataType().getByteLength()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getFPDataType().getByteLength()));
        return address;
    }

    @Override
    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getFPDataType().getByteLength());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getFPDataType().getByteLength()) / this.fRendering.getFPDataType().getByteLength();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    @Override
    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int subCellCharacterPosition = offset / this.getCellCharacterWidth();
                if (subCellCharacterPosition == this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength()));
                    subCellCharacterPosition = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + subCellCharacterPosition * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = subCellCharacterPosition;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    @Override
    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getFPDataType().getByteLength()));
        return address;
    }

    @Override
    protected void paint(PaintEvent pe) {
        super.paint(pe);
        this.doPaintData(pe);
    }

    protected void doPaintData(PaintEvent pe) {
        GC gc = pe.gc;
        gc.setFont(this.fRendering.getFont());
        int cellHeight = this.getCellHeight();
        int cellWidth = this.getCellWidth();
        int boundsHeight = this.getBounds().height;
        int columns = this.fRendering.getColumnCount();
        int cellX = 0;
        int cellY = 0;
        String displayString = FPutilities.fillString(this.fRendering.getCharsPerColumn(), '.');
        try {
            BigInteger vpStart;
            BigInteger cellStartAddr = vpStart = this.fRendering.getViewportStartAddress();
            BigInteger memoryAddr = vpStart;
            int row = 0;
            while (row < boundsHeight / cellHeight) {
                int column = 0;
                while (column < columns) {
                    if (this.isOdd(column)) {
                        gc.setForeground(this.fRendering.getFPRendering().getColorText());
                    } else {
                        gc.setForeground(this.fRendering.getFPRendering().getColorTextAlternate());
                    }
                    cellStartAddr = vpStart.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + column) * this.fRendering.getFPDataType().getByteLength()));
                    BigInteger cellEndAddr = cellStartAddr.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength()).subtract(BigInteger.ONE));
                    cellX = cellWidth * column + this.fRendering.getCellPadding();
                    cellY = cellHeight * row + this.fRendering.getCellPadding();
                    if (this.fRendering.isEditingCell() && cellStartAddr.equals(this.fRendering.getCellEditAddress())) {
                        FPMemoryByte[] memoryBytes;
                        gc.setForeground(this.fRendering.getFPRendering().getColorEdit());
                        FPMemoryByte[] fPMemoryByteArray = memoryBytes = this.fRendering.getBytes(cellStartAddr, this.fRendering.getFPDataType().getByteLength());
                        int n = memoryBytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FPMemoryByte memoryByte = fPMemoryByteArray[n2];
                            memoryByte.setEdited(true);
                            ++n2;
                        }
                        this.applyCustomColor(gc, memoryBytes, column);
                        displayString = this.fRendering.getEditBuffer().toString();
                    } else {
                        displayString = this.bytesToSciNotation(this.fRendering.getBytes(memoryAddr, this.fRendering.getFPDataType().getByteLength()));
                    }
                    if (this.fRendering.getSelection().isSelected(cellStartAddr)) {
                        gc.setBackground(this.fRendering.getFPRendering().getColorSelection());
                        gc.fillRectangle(cellX, row * cellHeight, cellWidth, cellHeight);
                        gc.setForeground(this.fRendering.getFPRendering().getColorBackground());
                    } else {
                        gc.setBackground(this.fRendering.getFPRendering().getColorBackground());
                        gc.fillRectangle(cellX, row * cellHeight, cellWidth, cellHeight);
                        this.applyCustomColor(gc, this.fRendering.getBytes(cellStartAddr, this.fRendering.getFPDataType().getByteLength()), column);
                    }
                    gc.drawText(displayString, cellX, cellY);
                    if (this.fCaretEnabled && cellStartAddr.compareTo(this.fCaretAddress) <= 0 && cellEndAddr.compareTo(this.fCaretAddress) >= 0) {
                        int x = cellWidth * column + this.fRendering.getCellPadding() + this.fSubCellCaretPosition * this.getCellCharacterWidth();
                        int y = cellHeight * row + this.fRendering.getCellPadding();
                        this.fCaret.setLocation(x, y);
                    }
                    if (this.fRendering.isDebug()) {
                        gc.drawRectangle(cellX, cellY, cellWidth, cellHeight);
                    }
                    memoryAddr = memoryAddr.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength()));
                    ++column;
                }
                ++row;
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_PAINT"), e);
            e.printStackTrace();
        }
    }

    protected void applyCustomColor(GC gc, FPMemoryByte[] bytes, int col) {
        boolean anyByteEditing = false;
        int n = 0;
        while (n < bytes.length && !anyByteEditing) {
            if (bytes[n].isEdited()) {
                anyByteEditing = true;
            }
            ++n;
        }
        boolean bl = anyByteEditing = anyByteEditing && this.fRendering.isEditingCell();
        if (this.isOdd(col)) {
            gc.setForeground(this.fRendering.getFPRendering().getColorText());
        } else {
            gc.setForeground(this.fRendering.getFPRendering().getColorTextAlternate());
        }
        gc.setBackground(this.fRendering.getFPRendering().getColorBackground());
        if (anyByteEditing) {
            gc.setForeground(this.fRendering.getFPRendering().getColorEdit());
        } else {
            boolean isColored = false;
            int index = 0;
            while (index < this.fRendering.getHistoryDepth() && !isColored) {
                int n2 = 0;
                while (n2 < bytes.length) {
                    if (bytes[n2].isChanged(index)) {
                        if (index == 0) {
                            gc.setForeground(this.fRendering.getFPRendering().getColorsChanged()[index]);
                        } else {
                            gc.setBackground(this.fRendering.getFPRendering().getColorsChanged()[index]);
                        }
                        isColored = true;
                        break;
                    }
                    ++n2;
                }
                ++index;
            }
        }
    }

    public void highCellBox(BigInteger memoryAddress) {
    }

    public void clearCellBox(BigInteger memoryAddress) {
    }
}

