/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { GDBBackend } from '../GDBBackend';
import { MIBreakpointInfo, MIResponse } from './base';
export interface MIBreakInsertResponse extends MIResponse {
    bkpt: MIBreakpointInfo;
    /**
     * In cases where GDB inserts multiple breakpoints, the "children"
     * breakpoints will be stored in multiple field.
     */
    multiple?: MIBreakpointInfo[];
}
export interface MIBreakDeleteRequest {
}
export interface MIBreakDeleteResponse extends MIResponse {
}
export interface MIBreakListResponse extends MIResponse {
    BreakpointTable: {
        nr_rows: string;
        nr_cols: string;
        hrd: Array<{
            width: string;
            alignment: string;
            col_name: string;
            colhdr: string;
        }>;
        body: MIBreakpointInfo[];
    };
}
export declare function sendBreakInsert(gdb: GDBBackend, request: {
    temporary?: boolean;
    hardware?: boolean;
    pending?: boolean;
    disabled?: boolean;
    tracepoint?: boolean;
    condition?: string;
    ignoreCount?: number;
    threadId?: string;
    source: string;
    line: number;
}): Promise<MIBreakInsertResponse>;
export declare function sendBreakDelete(gdb: GDBBackend, request: {
    breakpoints: string[];
}): Promise<MIBreakDeleteResponse>;
export declare function sendBreakList(gdb: GDBBackend): Promise<MIBreakListResponse>;
export declare function sendBreakFunctionInsert(gdb: GDBBackend, fn: string): Promise<MIBreakInsertResponse>;
