/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.mandas.docker.client.EventReader;
import org.mandas.docker.client.messages.Event;

public class EventStream
implements Iterator<Event>,
Closeable {
    private final EventReader reader;
    private Event next;

    EventStream(CloseableHttpResponse response, ObjectMapper objectMapper) {
        this.reader = new EventReader(response, objectMapper);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.next != null;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Event value = this.next;
        this.next = null;
        return value;
    }
}

