/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.filters;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;

public class SingleThreadFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (parentElement instanceof TreePath) {
            parentElement = ((TreePath)parentElement).getLastSegment();
        }
        if (parentElement instanceof IProcessContextNode && element instanceof IProcessContextNode) {
            final AtomicBoolean selected = new AtomicBoolean(true);
            final Object pe = parentElement;
            final Object e = element;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IProcessContextNode parent = (IProcessContextNode)pe;
                    IProcessContextNode child = (IProcessContextNode)e;
                    if (parent.getChildren().length == 1 && parent.getSysMonitorContext() != null && child.getSysMonitorContext() != null && parent.getSysMonitorContext().getPID() == child.getSysMonitorContext().getPID()) {
                        ISysMonitor.SysMonitorContext smc = parent.getSysMonitorContext();
                        if (Integer.valueOf(1).equals(smc.getProperties().get("ExeType"))) {
                            selected.set(false);
                        } else if (parent.getName() != null) {
                            selected.set(!parent.getName().equals(child.getName()));
                        } else if (child.getName() != null) {
                            selected.set(!child.getName().equals(parent.getName()));
                        }
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            return selected.get();
        }
        return true;
    }
}

