/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.autosave;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveAllListener
implements IExecutionListener {
    List<IFSTreeNode> fDirtyNodes = new ArrayList<IFSTreeNode>();

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (!this.fDirtyNodes.isEmpty()) {
            if (UIPlugin.isAutoSaving()) {
                UiExecutor.execute(ModelManager.operationUpload(this.fDirtyNodes));
            } else {
                for (IFSTreeNode dirtyNode : this.fDirtyNodes) {
                    dirtyNode.operationRefresh(false).runInJob(null);
                }
            }
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        IEditorPart[] editors;
        this.fDirtyNodes.clear();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        IWorkbenchPage page = window.getActivePage();
        IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            IEditorInput input = editor.getEditorInput();
            IFSTreeNode node = null;
            if (input instanceof IURIEditorInput) {
                IURIEditorInput fileInput = (IURIEditorInput)input;
                URI uri = fileInput.getURI();
                try {
                    IFileStore store = EFS.getStore((URI)uri);
                    File localFile = store.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                    if (localFile != null) {
                        IResultOperation parser = ModelManager.operationRestoreFromPath((String)localFile.getCanonicalPath());
                        parser.run(null);
                        node = (IFSTreeNode)parser.getResult();
                        if (node != null) {
                            this.fDirtyNodes.add(node);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }
}

