/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;
import org.eclipse.tcf.te.runtime.stepper.steps.AbstractStep;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;

public class CancelJobsStep
extends AbstractStep {
    @Override
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final IStepContext context, final IPropertiesContainer data, IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, ICallback callback) {
        StepperJob thisJob = (StepperJob)((Object)StepperAttributeUtil.getProperty("org.eclipse.tcf.te.runtime.stepper.stepper_job", fullQualifiedId, data));
        final AsyncCallbackCollector collector = new AsyncCallbackCollector();
        HashMap<String, List<Job>> jobs = new HashMap<String, List<Job>>(StepperJob.getJobs(context.getContextObject()));
        final AtomicInteger canceledJobs = new AtomicInteger(0);
        final ArrayList<Job> jobsToCancel = new ArrayList<Job>();
        HashMap<String, List<Job>> hashMap = jobs;
        synchronized (hashMap) {
            for (String op : jobs.keySet()) {
                for (Job job : (List)jobs.get(op)) {
                    if (job == thisJob || job instanceof StepperJob && !((StepperJob)job).isCancelable()) continue;
                    jobsToCancel.add(job);
                }
            }
        }
        for (Job job : jobsToCancel) {
            if (job instanceof StepperJob && ((StepperJob)job).isCancelable()) {
                Callback jobCb = new Callback(((StepperJob)job).getJobCallback()){

                    protected void internalDone(Object caller, IStatus status) {
                        canceledJobs.incrementAndGet();
                        ProgressHelper.worked((IProgressMonitor)monitor, (int)(CancelJobsStep.this.getTotalWork(context, data) / jobsToCancel.size()));
                        ProgressHelper.setSubTaskName((IProgressMonitor)monitor, (String)(String.valueOf(canceledJobs.get()) + " of " + jobsToCancel.size() + " Jobs canceled."));
                        collector.removeCallback((ICallback)this);
                    }
                };
                if (job.getState() == 4) {
                    collector.addCallback((ICallback)jobCb);
                    ((StepperJob)job).setJobCallback((ICallback)jobCb);
                } else {
                    canceledJobs.incrementAndGet();
                }
            } else {
                canceledJobs.incrementAndGet();
            }
            job.cancel();
        }
        collector.initDone();
        ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)collector.getConditionTester());
        callback.done((Object)this, Status.OK_STATUS);
    }
}

