/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.helper.filter.FilterService;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.osgi.framework.Version;

public class ActivatedFilterSortingMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION_FILTER_SORTING = new Version("14.3.0.201909031200");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION_FILTER_SORTING;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION_FILTER_SORTING) < 0) {
            int updateDiagrams = 0;
            Collection<DDiagram> diagramWithActivatedfilters = this.getDiagramWithActivatedFilters(dAnalysis);
            for (DDiagram dDiagram : diagramWithActivatedfilters) {
                boolean migrationOccured = this.sortActivatedFilters(dDiagram);
                if (!migrationOccured) continue;
                ++updateDiagrams;
            }
            if (updateDiagrams > 0) {
                String migrationMessage = MessageFormat.format(Messages.ActivatedFilterSortingMigrationParticipant_updatedDiagrams, updateDiagrams);
                DiagramPlugin.getDefault().logInfo(migrationMessage);
            }
        }
    }

    private boolean sortActivatedFilters(DDiagram diagram) {
        EList activatedFilter = diagram.getActivatedFilters();
        List<FilterDescription> sortedFilters = FilterService.sortFilters((Collection<FilterDescription>)activatedFilter);
        if (!Iterables.elementsEqual(sortedFilters, (Iterable)activatedFilter)) {
            activatedFilter.clear();
            activatedFilter.addAll(sortedFilters);
            return true;
        }
        return false;
    }

    private Collection<DDiagram> getDiagramWithActivatedFilters(DAnalysis dAnalysis) {
        Stream<DRepresentation> representationStream = dAnalysis.getOwnedViews().stream().flatMap(view -> view.getOwnedRepresentationDescriptors().stream()).map(desc -> desc.getRepresentation());
        return representationStream.filter(DDiagram.class::isInstance).map(DDiagram.class::cast).filter(diagram -> !diagram.getActivatedFilters().isEmpty()).collect(Collectors.toList());
    }
}

