/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;

public class DStoreInputStream
extends InputStream {
    private DataStore _dataStore;
    private String _remotePath;
    private DataElement _minerElement;
    private String _encoding;
    private int _mode;
    private DataElement _cmdStatus;
    private File _localFile;
    private InputStream _localFileInputStream;
    private int _bufferSize;
    private long _bytesRead = 0L;

    public DStoreInputStream(DataStore dataStore, String remotePath, DataElement minerElement, String encoding, int mode, int bufferSize) {
        this._dataStore = dataStore;
        this._remotePath = remotePath;
        this._minerElement = minerElement;
        this._encoding = encoding;
        this._mode = mode;
        this._bufferSize = bufferSize;
        this.initDownload();
    }

    protected void initDownload() {
        DataStore ds = this._dataStore;
        DataElement universaltemp = this._minerElement;
        DataElement de = this._dataStore.createObject(universaltemp, "universal.FileObject", this._remotePath, this._remotePath, "", false);
        try {
            this._localFile = File.createTempFile("download", "rse");
            this._localFile.deleteOnExit();
            DataElement remoteElement = ds.createObject(universaltemp, de.getType(), this._remotePath, String.valueOf(this._mode));
            DataElement localElement = ds.createObject(universaltemp, de.getType(), this._localFile.getAbsolutePath(), this._encoding);
            DataElement bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "" + this._bufferSize, "");
            DataElement queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
            ArrayList<DataElement> argList = new ArrayList<DataElement>();
            argList.add(remoteElement);
            argList.add(localElement);
            argList.add(bufferSizeElement);
            DataElement subject = ds.createObject(universaltemp, de.getType(), this._remotePath, String.valueOf(this._mode));
            this._cmdStatus = ds.command(queryCmd, argList, subject);
            this.waitForTempFile();
            this._localFileInputStream = new FileInputStream(this._localFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected DataStore getDataStore() {
        return this._dataStore;
    }

    protected DataElement getCommandDescriptor(DataElement subject, String command) {
        DataElement cmd = this._dataStore.localDescriptorQuery(subject.getDescriptor(), command);
        return cmd;
    }

    public void close() throws IOException {
        if (this._localFileInputStream != null) {
            this._localFileInputStream.close();
        }
    }

    protected void waitForTempFile() {
        if (this._localFile != null) {
            while (this._localFile.length() == 0L && !this.isTransferCommandDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isTransferCommandDone() {
        boolean done = this._cmdStatus.getValue().equals("done");
        return done;
    }

    public int read() throws IOException {
        if (this._localFileInputStream != null) {
            this.waitUntilAvailable(this._bytesRead + 1L);
            int result = this._localFileInputStream.read();
            if (result > 0) {
                ++this._bytesRead;
            }
            return result;
        }
        return 0;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._localFileInputStream != null) {
            this.waitUntilAvailable(this._bytesRead + (long)len);
            int result = this._localFileInputStream.read(b, off, len);
            if (result > 0) {
                this._bytesRead += (long)result;
            }
            return result;
        }
        return 0;
    }

    public int read(byte[] b) throws IOException {
        if (this._localFileInputStream != null) {
            this.waitUntilAvailable(this._bytesRead + (long)b.length);
            int result = this._localFileInputStream.read(b);
            if (result > 0) {
                this._bytesRead += (long)result;
            }
            return result;
        }
        return 0;
    }

    private void waitUntilAvailable(long desiredAvailable) {
        while (this._localFile.length() < desiredAvailable && !this.isTransferCommandDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int available() throws IOException {
        if (this._localFileInputStream != null) {
            return this._localFileInputStream.available();
        }
        return 0;
    }

    public long skip(long n) throws IOException {
        if (this._localFileInputStream != null) {
            this.waitUntilAvailable(this._bytesRead + n);
            long bytesSkipped = this._localFileInputStream.skip(n);
            if (bytesSkipped > 0L) {
                this._bytesRead += bytesSkipped;
            }
            return bytesSkipped;
        }
        return 0L;
    }
}

