/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.photran.internal.ui.views.vpgproblems.MarkerDispatchAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OpenMarkedFileAction
extends MarkerDispatchAction {
    public OpenMarkedFileAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.OpenMarkedFileAction_GoTo);
        this.setToolTipText(Messages.OpenMarkedFileAction_GoToTooltip);
    }

    public ImageDescriptor getImageDescriptor() {
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD_HOVER");
        return ImageDescriptor.createFromImage((Image)img);
    }

    @Override
    public void run(IMarker marker) {
        IWorkspaceRoot r = ResourcesPlugin.getWorkspace().getRoot();
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        IPath path = marker.getResource().getFullPath();
        IFile fileToOpen = r.getFile(path);
        try {
            OpenActionUtil.open((Object)fileToOpen, (boolean)true);
            IEditorPart editor = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            AbstractTextEditor textEditor = null;
            if (editor instanceof AbstractTextEditor) {
                textEditor = (AbstractTextEditor)editor;
            }
            if (textEditor != null) {
                textEditor.selectAndReveal(start, end - start);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
    }
}

