/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionParNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTNamedConstantDefNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class VariableCaseRefactoring
extends FortranResourceRefactoring {
    private boolean lowerCase = true;

    @Override
    public String getName() {
        return Messages.VariableCaseRefactoring_Name;
    }

    public void setLowerCase(boolean value) {
        this.lowerCase = value;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.VariableCaseRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws Error {
        try {
            if (ast == null) {
                return;
            }
            LoopReplacer.replaceAllLoopsIn(ast.getRoot());
            CaseChangingVisitor replacer = new CaseChangingVisitor();
            replacer.lowerCase = this.lowerCase;
            ast.accept(replacer);
            if (replacer.changedAST) {
                this.addChangeFromModifiedAST(file, pm);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private static final class CaseChangingVisitor
    extends ASTVisitorWithLoops {
        private boolean changedAST = false;
        private boolean lowerCase;

        private CaseChangingVisitor() {
        }

        @Override
        public void visitASTNameNode(ASTNameNode node) {
            this.checkNode(node);
        }

        @Override
        public void visitASTObjectNameNode(ASTObjectNameNode node) {
            this.checkNode(node);
        }

        private void checkNode(IASTNode node) {
            if (!this.identifierIsInFunctionCall(node) && !this.identifierIsInFunctionReturn(node)) {
                this.changeCaseOf(node.findFirstToken());
            }
        }

        @Override
        public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
            this.changeCaseOf(node.getIndexVariable());
            this.traverseChildren(node);
        }

        private boolean identifierIsInFunctionCall(IASTNode node) {
            ASTVarOrFnRefNode varOfFnNode;
            IASTNode parent = node.getParent();
            return parent instanceof ASTVarOrFnRefNode && (varOfFnNode = (ASTVarOrFnRefNode)parent).getPrimarySectionSubscriptList() != null;
        }

        private boolean identifierIsInFunctionReturn(IASTNode node) {
            ASTFunctionSubprogramNode functionNode;
            String functionName;
            IASTNode parent = node.getParent();
            while (parent != null && !(parent instanceof ASTFunctionSubprogramNode)) {
                parent = parent.getParent();
            }
            return parent != null && (functionName = (functionNode = (ASTFunctionSubprogramNode)parent).getFunctionStmt().getFunctionName().getFunctionName().getText()).equals(node.findFirstToken().getText());
        }

        @Override
        public void visitASTNamedConstantDefNode(ASTNamedConstantDefNode node) {
            this.changeCaseOf(node.findFirstToken());
        }

        @Override
        public void visitASTCommonBlockObjectNode(ASTCommonBlockObjectNode node) {
            this.changeCaseOf(node.findFirstToken());
        }

        @Override
        public void visitASTSubroutineParNode(ASTSubroutineParNode node) {
            this.changeCaseOf(node.findFirstToken());
        }

        @Override
        public void visitASTFunctionParNode(ASTFunctionParNode node) {
            this.changeCaseOf(node.findFirstToken());
        }

        private void changeCaseOf(Token node) {
            if (this.lowerCase) {
                node.findFirstToken().setText(node.getText().toLowerCase());
            } else {
                node.findFirstToken().setText(node.getText().toUpperCase());
            }
            this.changedAST = true;
        }
    }
}

