/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class AddIdentifierToEndRefactoring
extends FortranResourceRefactoring {
    @Override
    public String getName() {
        return Messages.AddIdentifierToEndRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.AddIdentifierToEndRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) {
        if (ast == null) {
            return;
        }
        ast.accept(new ReplaceEndTokenVisitor());
        this.addChangeFromModifiedAST(file, pm);
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private final class ReplaceEndTokenVisitor
    extends ASTVisitor {
        private ReplaceEndTokenVisitor() {
        }

        @Override
        public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
            if (!node.getEndSubroutineStmt().hasEndSubroutine()) {
                node.getEndSubroutineStmt().accept(new ASTVisitor(){

                    @Override
                    public void visitToken(Token token) {
                        if (token.getTerminal() == Terminal.T_END) {
                            token.replaceWith(new Token(Terminal.T_ENDSUBROUTINE, token.getWhiteBefore(), "end subroutine", ""));
                        }
                    }
                });
            }
            String identifier = String.valueOf(node.getSubroutineStmt().getSubroutineName().getSubroutineName().getWhiteBefore()) + node.getSubroutineStmt().getSubroutineName().getSubroutineName().getText();
            node.getEndSubroutineStmt().setEndName(new Token(Terminal.T_IDENT, identifier));
            this.traverseChildren(node);
        }

        @Override
        public void visitASTMainProgramNode(ASTMainProgramNode node) {
            if (node.getProgramStmt() != null) {
                this.replaceEndProgramStmt(node);
            }
            this.traverseChildren(node);
        }

        private void replaceEndProgramStmt(ASTMainProgramNode node) {
            if (!node.getEndProgramStmt().hasEndProgram()) {
                node.getEndProgramStmt().accept(new ASTVisitor(){

                    @Override
                    public void visitToken(Token token) {
                        if (token.getTerminal() == Terminal.T_END) {
                            token.replaceWith(new Token(Terminal.T_ENDPROGRAM, token.getWhiteBefore(), "end program", ""));
                        }
                    }
                });
            }
            String identifier = String.valueOf(node.getProgramStmt().getProgramName().getProgramName().getWhiteBefore()) + node.getProgramStmt().getProgramName().getProgramName().getText();
            node.getEndProgramStmt().setEndName(new Token(Terminal.T_ENDPROGRAM, identifier));
        }

        @Override
        public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
            if (!node.getEndFunctionStmt().hasEndFunction()) {
                node.getEndFunctionStmt().accept(new ASTVisitor(){

                    @Override
                    public void visitToken(Token token) {
                        if (token.getTerminal() == Terminal.T_END) {
                            token.replaceWith(new Token(Terminal.T_ENDFUNCTION, token.getWhiteBefore(), "end function", ""));
                        }
                    }
                });
            }
            String identifier = String.valueOf(node.getFunctionStmt().getFunctionName().getFunctionName().getWhiteBefore()) + node.getFunctionStmt().getFunctionName().getFunctionName().getText();
            node.getEndFunctionStmt().setEndName(new Token(Terminal.T_ENDFUNCTION, identifier));
            this.traverseChildren(node);
        }

        @Override
        public void visitASTModuleNode(ASTModuleNode node) {
            if (!node.getEndModuleStmt().hasEndModule()) {
                node.accept(new ASTVisitor(){

                    @Override
                    public void visitToken(Token token) {
                        if (token.getTerminal() == Terminal.T_END) {
                            token.replaceWith(new Token(Terminal.T_ENDMODULE, token.getWhiteBefore(), "end module", ""));
                        }
                    }
                });
            }
            String identifier = String.valueOf(node.getModuleStmt().getModuleName().getModuleName().getWhiteBefore()) + node.getModuleStmt().getModuleName().getModuleName().getText();
            node.getEndModuleStmt().setEndName(new Token(Terminal.T_ENDMODULE, identifier));
            this.traverseChildren(node);
        }
    }
}

