/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.util.DisplayUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.papyrus.uml.xtext.integration.CustomCompletionProposal;
import org.eclipse.papyrus.uml.xtext.integration.ui.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public class CompletionProposalUtils {
    @Deprecated(since="3.1.0", forRemoval=true)
    protected static final ILabelProvider labelProvider = DisplayUtils.getLabelProvider();

    protected static final ILabelProvider getLabelProvider(EObject eobject) {
        try {
            LabelProviderService service = (LabelProviderService)ServiceUtilsForSelection.getInstance().getService(LabelProviderService.class, (Object)new StructuredSelection((Object)eobject));
            if (service != null) {
                return service.getLabelProvider((Object)eobject);
            }
        }
        catch (ServiceException e) {
            Activator.log.error("Label provider service not found", (Throwable)e);
        }
        return null;
    }

    public static CustomCompletionProposal createCompletionProposal(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        StringBuilder builder = new StringBuilder(namedElement.getQualifiedName());
        builder.append("\n").append('(').append(namedElement.eClass().getName()).append(')');
        String additionalProposalInfo = builder.toString();
        Image image = null;
        ILabelProvider provider = CompletionProposalUtils.getLabelProvider((EObject)namedElement);
        if (provider != null) {
            image = provider.getImage((Object)namedElement);
        }
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), image, " " + displayString, null, additionalProposalInfo, context);
        return completionProposal;
    }

    public static CustomCompletionProposal createCompletionProposalWithReplacementOfPrefix(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        StringBuilder builder = new StringBuilder(namedElement.getQualifiedName());
        builder.append("\n").append('(').append(namedElement.eClass().getName()).append(')');
        String additionalProposalInfo = builder.toString();
        Image image = null;
        ILabelProvider provider = CompletionProposalUtils.getLabelProvider((EObject)namedElement);
        if (provider != null) {
            image = provider.getImage((Object)namedElement);
        }
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset() - context.getPrefix().length(), context.getPrefix().length(), completionString.length(), image, " " + displayString, null, additionalProposalInfo, context);
        return completionProposal;
    }

    public static CustomCompletionProposal createCompletionProposal(String completionString, String displayString, ContentAssistContext context) {
        CustomCompletionProposal completionProposal = new CustomCompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), null, " " + displayString, null, null, context);
        return completionProposal;
    }

    public static String getQualifiedNameLabelWithSufficientDepth(NamedElement namedElement, Namespace model) {
        int qualifiedNameDepht;
        Assert.isNotNull((Object)namedElement);
        StringBuffer label = new StringBuffer();
        ArrayList importedPackages = null;
        if (model != null) {
            importedPackages = new ArrayList(model.getImportedPackages());
        }
        ArrayList<Namespace> visitedNamespaces = new ArrayList<Namespace>();
        Namespace currentNamespace = namedElement.getNamespace();
        boolean rootFound = false;
        boolean modelIsTheRoot = false;
        while (currentNamespace != null && !rootFound) {
            visitedNamespaces.add(currentNamespace);
            if (importedPackages != null && (importedPackages.contains(currentNamespace) || currentNamespace.equals(model))) {
                rootFound = true;
                if (currentNamespace.equals(model)) {
                    modelIsTheRoot = true;
                }
            }
            Element owner = currentNamespace.getOwner();
            while (owner != null && !(owner instanceof Namespace)) {
                owner = owner.getOwner();
            }
            Namespace namespace = currentNamespace = owner != null ? (Namespace)owner : null;
        }
        int i = qualifiedNameDepht = visitedNamespaces.size() - 1 - (modelIsTheRoot ? 1 : 0);
        while (i >= 0) {
            label.append(((Namespace)visitedNamespaces.get(i)).getName());
            label.append("::");
            --i;
        }
        label.append(namedElement.getName());
        return label.toString();
    }
}

