/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

abstract class AbstractProfileApplicationSelectionPage<I, P>
extends WizardPage {
    private final Class<P> elementType;
    private CheckboxTableViewer profilesTable;
    private I input;
    private List<P> initialSelections;

    public AbstractProfileApplicationSelectionPage(String name, String title, ImageDescriptor icon, Class<P> elementType) {
        super(name, title, icon);
        this.elementType = elementType;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        int layoutCols = this.getLayoutColumnCount();
        main.setLayout((Layout)new GridLayout(layoutCols, false));
        AbstractProfileApplicationSelectionPage.span(AbstractProfileApplicationSelectionPage.label(main, Messages.AbstractProfileApplicationSelectionPage_0), layoutCols);
        this.profilesTable = new CheckboxTableViewer(new Table(main, 2852));
        AbstractProfileApplicationSelectionPage.span(AbstractProfileApplicationSelectionPage.fill(this.profilesTable.getTable(), true, true), layoutCols);
        this.profilesTable.setContentProvider((IContentProvider)this.createProfilesContentProvider());
        this.profilesTable.setLabelProvider(this.createProfilesLabelProvider());
        this.profilesTable.setComparator(new ViewerComparator());
        this.profilesTable.setInput(this.getInput());
        this.checkInitialSelections(this.profilesTable, this.initialSelections);
        this.profilesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractProfileApplicationSelectionPage.this.validatePage();
            }
        });
        this.createSelectionButtons(main);
        this.createAdditionalContents(main);
        this.setControl((Control)main);
        this.validatePage();
    }

    protected void checkInitialSelections(CheckboxTableViewer table, Collection<P> initialSelections) {
        if (initialSelections != null) {
            table.setCheckedElements(initialSelections.toArray());
        }
    }

    protected int getLayoutColumnCount() {
        return 2;
    }

    protected void createAdditionalContents(Composite mainArea) {
    }

    public void setInput(I input) {
        this.input = input;
        if (this.profilesTable != null) {
            this.profilesTable.setInput(input);
        }
    }

    public I getInput() {
        return this.input;
    }

    public void select(Iterable<P> profileApplications) {
        this.initialSelections = ImmutableList.copyOf(profileApplications);
        if (this.profilesTable != null) {
            this.profilesTable.setCheckedElements(this.initialSelections.toArray());
        }
    }

    public List<P> getSelectedProfileApplications() {
        Object[] raw = this.profilesTable.getCheckedElements();
        return ImmutableList.copyOf((Iterable)Iterables.filter(Arrays.asList(raw), this.elementType));
    }

    private void createSelectionButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        AbstractProfileApplicationSelectionPage.span(buttons, this.getLayoutColumnCount());
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        buttons.setLayout((Layout)layout);
        class ButtonHandler
        extends SelectionAdapter {
            final boolean select;

            ButtonHandler(boolean select) {
                this.select = select;
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractProfileApplicationSelectionPage.this.profilesTable.setAllChecked(this.select);
                AbstractProfileApplicationSelectionPage.this.validatePage();
            }
        }
        AbstractProfileApplicationSelectionPage.button(buttons, Messages.AbstractProfileApplicationSelectionPage_1).addSelectionListener((SelectionListener)new ButtonHandler(true));
        AbstractProfileApplicationSelectionPage.button(buttons, Messages.AbstractProfileApplicationSelectionPage_2).addSelectionListener((SelectionListener)new ButtonHandler(false));
    }

    protected abstract IStructuredContentProvider createProfilesContentProvider();

    protected abstract IBaseLabelProvider createProfilesLabelProvider();

    protected void validatePage() {
        if (this.profilesTable.getCheckedElements().length == 0) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    static GridData gd(Control c) {
        GridData result = (GridData)c.getLayoutData();
        if (result == null) {
            result = new GridData();
            c.setLayoutData((Object)result);
        }
        return result;
    }

    static Label label(Composite parent, String text) {
        Label result = new Label(parent, 0);
        result.setText(text);
        return result;
    }

    static Button button(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        return result;
    }

    static <C extends Control> C span(C c, int horizontal) {
        AbstractProfileApplicationSelectionPage.gd(c).horizontalSpan = horizontal;
        return c;
    }

    static <C extends Control> C lead(C c, int dlus) {
        AbstractProfileApplicationSelectionPage.gd(c).verticalIndent = dlus;
        return c;
    }

    static <C extends Control> C fill(C c, boolean horizontal, boolean vertical) {
        GridData gd = AbstractProfileApplicationSelectionPage.gd(c);
        if (horizontal) {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        if (vertical) {
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
        }
        return c;
    }

    static <C extends Control> C align(C c, int align) {
        GridData gd = AbstractProfileApplicationSelectionPage.gd(c);
        gd.horizontalAlignment = align;
        return c;
    }
}

