/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class BundleExplorerDialog
extends FilteredItemsSelectionDialog {
    protected static final String EMPTY = "";
    protected static final String DIALOG_SETTINGS = "org.eclipse.papyrus.infra.widgets.toolbox.BundleExplorerDialog";
    protected IPluginModelBase[] fModels;

    public BundleExplorerDialog(Shell shell, boolean multi, IPluginModelBase[] models) {
        super(shell, multi);
        this.setTitle(Messages.BundleExplorerDialog_PlugInSelectionTitle);
        this.setMessage(Messages.BundleExplorerDialog_DialogMessage);
        this.fModels = models;
        this.setListLabelProvider((ILabelProvider)new LabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PluginSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        int i = 0;
        while (i < this.fModels.length) {
            contentProvider.add((Object)this.fModels[i], itemsFilter);
            progressMonitor.worked(1);
            ++i;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)item;
            return model.getPluginBase().getId();
        }
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        return new PluginSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.papyrus.infra.widgets", 0, EMPTY, null);
    }

    private class PluginSearchComparator
    implements Comparator {
        private PluginSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            return id1 != (id2 = this.getId(o2)) ? id1 - id2 : this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            return element instanceof IPluginModelBase ? 100 : 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IPluginModelBase && o2 instanceof IPluginModelBase) {
                IPluginModelBase ipmb1 = (IPluginModelBase)o1;
                IPluginModelBase ipmb2 = (IPluginModelBase)o2;
                return this.comparePlugins(ipmb1.getPluginBase(), ipmb2.getPluginBase());
            }
            return 0;
        }

        private int comparePlugins(IPluginBase ipmb1, IPluginBase ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class PluginSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private static final String DOT = ".";
        private static final String INTERROGATION = "?";
        private static final String ASTERISK = "*";

        private PluginSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)BundleExplorerDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)item;
                id = model.getPluginBase().getId();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf(ASTERISK) != 0 && pattern.indexOf(INTERROGATION) != 0 && pattern.indexOf(DOT) != 0) {
                pattern = ASTERISK + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

