/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public class WritableListWithIterator<E>
extends WritableList<E>
implements ReferenceCountedObservable {
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support(this);
    private final ListDiffVisitor<E> mutationHook = this.createMutationHook();

    public WritableListWithIterator() {
    }

    public WritableListWithIterator(Realm realm) {
        super(realm);
    }

    public WritableListWithIterator(List<E> toWrap, Object elementType) {
        super(toWrap, elementType);
    }

    public WritableListWithIterator(Collection<E> collection, Object elementType) {
        super(collection, elementType);
    }

    public WritableListWithIterator(Realm realm, List<E> toWrap, Object elementType) {
        super(realm, toWrap, elementType);
    }

    public WritableListWithIterator(Realm realm, Collection<E> collection, Object elementType) {
        super(realm, collection, elementType);
    }

    void didAdd(E element) {
    }

    void didRemove(E element) {
    }

    private ListDiffVisitor<E> createMutationHook() {
        return new ListDiffVisitor<E>(){

            public void handleAdd(int index, E element) {
                WritableListWithIterator.this.didAdd(element);
            }

            public void handleRemove(int index, E element) {
                WritableListWithIterator.this.didRemove(element);
            }
        };
    }

    protected void fireListChange(ListDiff<E> diff) {
        diff.accept(this.mutationHook);
        super.fireListChange(diff);
    }

    @Override
    public void retain() {
        this.refCount.retain();
    }

    @Override
    public void release() {
        this.refCount.release();
    }

    @Override
    public void autorelease() {
        this.refCount.autorelease();
    }

    public Iterator<E> iterator() {
        this.getterCalled();
        return new Iter();
    }

    public ListIterator<E> listIterator() {
        this.getterCalled();
        return new ListIter(0);
    }

    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        return new ListIter(index);
    }

    static <E> ListDiffEntry<E> added(E element, int position) {
        return Diffs.createListDiffEntry((int)position, (boolean)true, element);
    }

    static <E> ListDiffEntry<E> removed(E element, int position) {
        return Diffs.createListDiffEntry((int)position, (boolean)false, element);
    }

    public static class Containment<E extends ReferenceCountedObservable>
    extends WritableListWithIterator<E> {
        public Containment() {
        }

        public Containment(Object elementType) {
            super(new ArrayList(), elementType);
        }

        public Containment(Realm realm, Object elementType) {
            super(realm, new ArrayList(), elementType);
        }

        public Containment(Realm realm) {
            super(realm);
        }

        public synchronized void dispose() {
            super.dispose();
            this.wrappedList.forEach(ReferenceCountedObservable::release);
            this.wrappedList.clear();
        }

        @Override
        void didAdd(E element) {
            if (element != null) {
                element.retain();
            }
        }

        @Override
        void didRemove(E element) {
            if (element != null) {
                element.release();
            }
        }
    }

    private class Iter
    implements Iterator<E> {
        final ListIterator<E> delegate;
        int lastReturned = -1;

        Iter() {
            this(0);
        }

        Iter(int index) {
            this.delegate = WritableListWithIterator.this.wrappedList.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            Object result = this.delegate.next();
            this.lastReturned = this.delegate.previousIndex();
            return result;
        }

        E lastReturned() {
            return this.lastReturned >= 0 && this.lastReturned < WritableListWithIterator.this.size() ? WritableListWithIterator.this.get(this.lastReturned) : null;
        }

        @Override
        public void remove() {
            Object removed = this.lastReturned();
            this.delegate.remove();
            WritableListWithIterator.this.fireListChange(Diffs.createListDiff(WritableListWithIterator.removed(removed, this.lastReturned)));
        }
    }

    private class ListIter
    extends Iter
    implements ListIterator<E> {
        ListIter(int index) {
            super(index);
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public E previous() {
            Object result = this.delegate.previous();
            this.lastReturned = this.delegate.nextIndex();
            return result;
        }

        @Override
        public void set(E e) {
            Object removed = this.lastReturned();
            this.delegate.set(e);
            WritableListWithIterator.this.fireListChange(Diffs.createListDiff(WritableListWithIterator.removed(removed, this.lastReturned), WritableListWithIterator.added(e, this.lastReturned)));
        }

        @Override
        public void add(E e) {
            this.delegate.add(e);
            WritableListWithIterator.this.fireListChange(Diffs.createListDiff(WritableListWithIterator.added(e, this.previousIndex())));
        }
    }
}

