/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattableFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.NattablecelleditorFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;

public class TableHelper {
    private TableHelper() {
    }

    public static final Table createTable(TableConfiguration configuration) {
        return TableHelper.createTable(configuration, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context) {
        return TableHelper.createTable(configuration, context, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context, String name) {
        return TableHelper.createTable(configuration, context, name, null);
    }

    @Deprecated
    public static final Table createTable(TableConfiguration configuration, EObject context, String name, String description) {
        return TableHelper.createTable(configuration, context, name, description, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context, String name, String description, String tableKindId) {
        Assert.isNotNull((Object)configuration);
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(configuration);
        table.setDescription(description);
        table.setName(name);
        table.setContext(context);
        table.setTableKindId(tableKindId);
        AbstractAxisProvider rowProvider = configuration.getDefaultRowAxisProvider();
        rowProvider = (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        AbstractAxisProvider columnProvider = configuration.getDefaultColumnAxisProvider();
        columnProvider = (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add((Object)rowProvider);
        table.getColumnAxisProvidersHistory().add((Object)columnProvider);
        IntListValueStyle style = (IntListValueStyle)configuration.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
        if (style != null) {
            IntListValueStyle copy = (IntListValueStyle)EcoreUtil.copy((EObject)style);
            table.getStyles().add((Object)copy);
        }
        if (TableHelper.isMatrixTreeTable(table)) {
            if (configuration.getOwnedCellEditorConfigurations() != null) {
                table.setOwnedCellEditorConfigurations((ICellEditorConfiguration)EcoreUtil.copy((EObject)configuration.getOwnedCellEditorConfigurations()));
            } else {
                GenericRelationshipMatrixCellEditorConfiguration conf = NattablecelleditorFactory.eINSTANCE.createGenericRelationshipMatrixCellEditorConfiguration();
                conf.setCellEditorId("GenericRelationshipMatrixEditorConfiguration");
                table.setOwnedCellEditorConfigurations((ICellEditorConfiguration)conf);
            }
            Assert.isNotNull((Object)table.getOwnedCellEditorConfigurations(), (String)"A matrix must own a CellEditorConfiguration");
        }
        return table;
    }

    public static final DisplayStyle getTableDisplayStyle(Table table) {
        DisplayStyle result = DisplayStyle.NORMAL;
        if (table != null) {
            TableDisplayStyle displayStyle = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
            if (displayStyle == null && table.getTableConfiguration() != null) {
                displayStyle = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
            }
            if (displayStyle != null) {
                result = displayStyle.getDisplayStyle();
            }
        }
        return result;
    }

    public static final DisplayStyle getTableDisplayStyle(INattableModelManager tableManager) {
        return tableManager != null ? TableHelper.getTableDisplayStyle(tableManager.getTable()) : null;
    }

    public static final boolean isTreeTable(INattableModelManager tableManager) {
        return tableManager != null ? TableHelper.isTreeTable(tableManager.getTable()) : false;
    }

    public static final boolean isTreeTable(Table table) {
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style == null) {
            style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isTreeTable(TableConfiguration tableConfiguration) {
        TableDisplayStyle style = (TableDisplayStyle)tableConfiguration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isSingleColumnTreeTable(TableConfiguration tableConfiguration) {
        TableDisplayStyle style = (TableDisplayStyle)tableConfiguration.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        Assert.isNotNull((Object)style);
        DisplayStyle displayStyle = style.getDisplayStyle();
        return DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
    }

    public static final boolean isSingleColumnTreeTable(Table table) {
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style == null) {
            style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isSingleColumnTreeTable(INattableModelManager tableManager) {
        return tableManager != null ? TableHelper.isSingleColumnTreeTable(tableManager.getTable()) : false;
    }

    public static final boolean isMultiColumnTreeTable(Table table) {
        if (table != null) {
            TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
            if (style == null) {
                style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
            }
            if (style != null) {
                return DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)style.getDisplayStyle());
            }
        }
        return false;
    }

    public static final boolean isMultiColumnTreeTable(INattableModelManager tableManager) {
        return tableManager != null && TableHelper.isMultiColumnTreeTable(tableManager.getTable());
    }

    public static final Table findTable(EObject anEObject) throws Exception {
        if (EcoreUtil.getRootContainer((EObject)anEObject.eClass()) != NattablePackage.eINSTANCE) {
            throw new Exception("The eobject is not an element of the Papyrus table metamodel");
        }
        EObject container = anEObject;
        while (container != null && !(container instanceof Table)) {
            container = container.eContainer();
        }
        if (container == null) {
            return null;
        }
        return (Table)container;
    }

    public static final CellEditorDeclaration getCellEditorDeclaration(INattableModelManager tableManager) {
        return tableManager != null ? TableHelper.getCellEditorDeclaration(tableManager.getTable()) : null;
    }

    public static final CellEditorDeclaration getCellEditorDeclaration(Table table) {
        CellEditorDeclaration declaration = table.getTableConfiguration().getCellEditorDeclaration();
        if (table.isInvertAxis()) {
            switch (declaration) {
                case COLUMN: {
                    return CellEditorDeclaration.ROW;
                }
                case ROW: {
                    return CellEditorDeclaration.COLUMN;
                }
            }
        }
        return declaration;
    }

    public static final void getPath(List<ITreeItemAxis> path, ITreeItemAxis element) {
        path.add(element);
        ITreeItemAxis parent = element.getParent();
        while (parent != null) {
            path.add(0, parent);
            parent = parent.getParent();
        }
    }

    public static final boolean isMatrixTreeTable(Table table) {
        AbstractAxisProvider rowsAxisProvider = table.getCurrentRowAxisProvider();
        AbstractAxisProvider columnsAxisProvider = table.getCurrentColumnAxisProvider();
        return TableHelper.isTreeTable(table) && rowsAxisProvider instanceof IMasterAxisProvider && columnsAxisProvider instanceof IMasterAxisProvider;
    }
}

