/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.commands.RenameDiagramLabelCommand;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers.AbstractDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.messages.Messages;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;

public class RenameDiagramHandler
extends AbstractDiagramCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<Diagram> diagrams = this.getSelectedDiagrams();
        if (editingDomain != null && diagrams.size() == 1) {
            Diagram diag = diagrams.get(0);
            String diagramLabel = LabelInternationalization.getInstance().getDiagramLabelWithoutName(diag);
            if (diagramLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)diag)) {
                RenameDiagramLabelCommand cmd = new RenameDiagramLabelCommand(editingDomain, "ChangeDiagramLabelCommand", (EObject)diag, diagramLabel, Messages.RenameDiagramHandler_Label_DialogTitle);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = diag.getName();
            if (currentName != null) {
                EStructuralFeature nameFeature = diag.eClass().getEStructuralFeature("name");
                return new RenameElementCommand(editingDomain, "RenameDiagramCommand", (EObject)diag, currentName, nameFeature, Messages.RenameDiagramHandler_RenameAnExistingDiagram, Messages.RenameDiagramHandler_NewName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedDiagram = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedDiagram)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedDiagram);
        } else {
            super.execute(event);
        }
        return null;
    }
}

