/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.ssl.SSLBufferFactory;
import org.eclipse.net4j.internal.tcp.ssl.SSLEngineManager;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.tcp.ssl.SSLUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class SSLConnector
extends TCPConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, SSLConnector.class);
    private SSLEngineManager sslEngineManager;

    @Override
    public String getProtocolString() {
        return "ssl://";
    }

    @Override
    public void handleConnect(ITCPSelector selector, SocketChannel channel) {
        super.handleConnect(selector, channel);
        if (!this.sslEngineManager.isHandshakeComplete() && this.isClient()) {
            this.getConfig().getReceiveExecutor().execute(this.createHandShakeTask(channel));
        }
    }

    @Override
    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        super.handleRegistration(selector, socketChannel);
        if (!this.sslEngineManager.isHandshakeComplete() && this.isServer()) {
            this.getConfig().getReceiveExecutor().execute(this.createHandShakeTask(socketChannel));
        }
    }

    @Override
    public void handleRead(ITCPSelector selector, SocketChannel socketChannel) {
        this.waitForHandShakeFinish();
        try {
            this.handleReadRethrowClosedChannelException(selector, socketChannel);
        }
        catch (ClosedChannelException ex) {
            return;
        }
        this.checkRehandShake(socketChannel);
        while (this.sslEngineManager.getPacketRecvBuf().position() > 0) {
            try {
                this.handleReadRethrowClosedChannelException(selector, socketChannel);
            }
            catch (ClosedChannelException ex) {
                return;
            }
            this.checkRehandShake(socketChannel);
        }
    }

    @Override
    public void handleWrite(ITCPSelector selector, SocketChannel socketChannel) {
        this.waitForHandShakeFinish();
        super.handleWrite(selector, socketChannel);
        this.checkRehandShake(socketChannel);
    }

    @Override
    protected void doActivate() throws Exception {
        try {
            boolean isClient = this.isClient();
            String host = this.getHost();
            int port = this.getPort();
            this.sslEngineManager = new SSLEngineManager(isClient, host, port, this.getConfig().getReceiveExecutor());
            this.getConfig().setBufferProvider((IBufferProvider)new SSLBufferFactory(this.sslEngineManager));
        }
        catch (Exception ex) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Cannot activate the ssl engine.", (Throwable)ex);
            }
            throw ex;
        }
        super.doActivate();
    }

    @Override
    protected void doDeactivate() throws Exception {
        try {
            try {
                this.sslEngineManager.close();
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Cannot deactivate the ssl engine.", (Throwable)ex);
                }
                super.doDeactivate();
            }
        }
        finally {
            super.doDeactivate();
        }
    }

    @Override
    protected void doOrderWriteInterest(boolean on) {
        ITCPSelector selector = this.getSelector();
        SelectionKey selectionKey = this.getSelectionKey();
        if (on) {
            selector.orderReadInterest(selectionKey, this.isClient(), false);
            selector.orderWriteInterest(selectionKey, this.isClient(), true);
        } else {
            selector.orderWriteInterest(selectionKey, this.isClient(), false);
            selector.orderReadInterest(selectionKey, this.isClient(), true);
        }
    }

    private void checkRehandShake(SocketChannel socketChannel) {
        if (!this.isClosed()) {
            try {
                this.sslEngineManager.checkRehandShake(socketChannel);
            }
            catch (Exception ex) {
                this.deactivateAsync();
            }
        }
    }

    private void waitForHandShakeFinish() {
        while (!this.sslEngineManager.isHandshakeComplete()) {
            if (this.isNegotiating()) {
                ConcurrencyUtil.sleep((long)SSLUtil.getHandShakeWaitTime());
                continue;
            }
            if (!this.isNegotiating() && !this.isActive()) break;
            Thread.yield();
        }
        if (!this.isNegotiating() && !this.isActive()) {
            try {
                this.deactivateAsync();
            }
            catch (Exception ex) {
                OM.LOG.warn((Throwable)ex);
            }
        }
    }

    private Runnable createHandShakeTask(SocketChannel channel) {
        final SocketChannel socket = channel;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    SSLConnector.this.sslEngineManager.checkInitialHandshake(socket);
                }
                catch (Exception ex) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("ssl cannot handshake.", (Throwable)ex);
                    }
                    SSLConnector.this.deferredActivate(false);
                }
            }
        };
        return task;
    }
}

