/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssignmentKind implements Enumerator
{
    ASSIGN(1, "ASSIGN", "="),
    PLUS_ASSIGN(2, "PLUS_ASSIGN", "+="),
    MINUS_ASSIGN(3, "MINUS_ASSIGN", "-="),
    TIMES_ASSIGN(4, "TIMES_ASSIGN", "*="),
    DIVIDE_ASSIGN(5, "DIVIDE_ASSIGN", "/="),
    BIT_AND_ASSIGN(6, "BIT_AND_ASSIGN", "&="),
    BIT_OR_ASSIGN(7, "BIT_OR_ASSIGN", "|="),
    BIT_XOR_ASSIGN(8, "BIT_XOR_ASSIGN", "^="),
    REMAINDER_ASSIGN(9, "REMAINDER_ASSIGN", "%="),
    LEFT_SHIFT_ASSIGN(10, "LEFT_SHIFT_ASSIGN", "<<="),
    RIGHT_SHIFT_SIGNED_ASSIGN(11, "RIGHT_SHIFT_SIGNED_ASSIGN", ">>="),
    RIGHT_SHIFT_UNSIGNED_ASSIGN(12, "RIGHT_SHIFT_UNSIGNED_ASSIGN", ">>>=");

    public static final int ASSIGN_VALUE = 1;
    public static final int PLUS_ASSIGN_VALUE = 2;
    public static final int MINUS_ASSIGN_VALUE = 3;
    public static final int TIMES_ASSIGN_VALUE = 4;
    public static final int DIVIDE_ASSIGN_VALUE = 5;
    public static final int BIT_AND_ASSIGN_VALUE = 6;
    public static final int BIT_OR_ASSIGN_VALUE = 7;
    public static final int BIT_XOR_ASSIGN_VALUE = 8;
    public static final int REMAINDER_ASSIGN_VALUE = 9;
    public static final int LEFT_SHIFT_ASSIGN_VALUE = 10;
    public static final int RIGHT_SHIFT_SIGNED_ASSIGN_VALUE = 11;
    public static final int RIGHT_SHIFT_UNSIGNED_ASSIGN_VALUE = 12;
    private static final AssignmentKind[] VALUES_ARRAY;
    public static final List<AssignmentKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssignmentKind[]{ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN, TIMES_ASSIGN, DIVIDE_ASSIGN, BIT_AND_ASSIGN, BIT_OR_ASSIGN, BIT_XOR_ASSIGN, REMAINDER_ASSIGN, LEFT_SHIFT_ASSIGN, RIGHT_SHIFT_SIGNED_ASSIGN, RIGHT_SHIFT_UNSIGNED_ASSIGN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssignmentKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentKind get(int value) {
        switch (value) {
            case 1: {
                return ASSIGN;
            }
            case 2: {
                return PLUS_ASSIGN;
            }
            case 3: {
                return MINUS_ASSIGN;
            }
            case 4: {
                return TIMES_ASSIGN;
            }
            case 5: {
                return DIVIDE_ASSIGN;
            }
            case 6: {
                return BIT_AND_ASSIGN;
            }
            case 7: {
                return BIT_OR_ASSIGN;
            }
            case 8: {
                return BIT_XOR_ASSIGN;
            }
            case 9: {
                return REMAINDER_ASSIGN;
            }
            case 10: {
                return LEFT_SHIFT_ASSIGN;
            }
            case 11: {
                return RIGHT_SHIFT_SIGNED_ASSIGN;
            }
            case 12: {
                return RIGHT_SHIFT_UNSIGNED_ASSIGN;
            }
        }
        return null;
    }

    private AssignmentKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

