/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.modisco.facet.util.ui.internal.Messages;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class QuestionDialog
implements IQuestionDialog {
    private static final int SHELL_WIDTH = 450;
    private static final int SHELL_HEIGHT = 170;
    private final Shell parentShell;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private Boolean result = null;
    private Shell shell;
    private Button btnYes;
    private Button btnNo;
    private final String title;
    private final String message;
    private IDialogCallback<Boolean> callback;

    public QuestionDialog(Shell parent, String title, String message, IDialogCallback<Boolean> callback) {
        this.parentShell = parent;
        this.title = title;
        this.message = message;
        this.callback = callback;
        this.createContents();
    }

    @Override
    public final void open() {
        this.shell.layout();
        if (this.parentShell != null) {
            Rectangle parentShellBounds = this.parentShell.getBounds();
            Point shellSize = this.shell.getSize();
            this.shell.setLocation(parentShellBounds.x + (parentShellBounds.width - shellSize.x) / 2, parentShellBounds.y + (parentShellBounds.height - shellSize.y) / 2);
        }
        this.shell.open();
    }

    private void createContents() {
        int buttonWidthHint = 80;
        this.shell = new Shell(this.parentShell, 67632);
        this.shell.setSize(450, 170);
        this.shell.setText(this.title);
        GridLayout shellLayout = new GridLayout(2, false);
        int marginLeft = 5;
        int marginTop = 8;
        int verticalSpacing = 10;
        int horizontalSpacing = 15;
        shellLayout.marginLeft = 5;
        shellLayout.marginTop = 8;
        shellLayout.verticalSpacing = 10;
        shellLayout.horizontalSpacing = 15;
        this.shell.setLayout((Layout)shellLayout);
        Label image = new Label((Composite)this.shell, 0);
        image.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        image.setImage(Display.getDefault().getSystemImage(4));
        Label labelMessage = new Label((Composite)this.shell, 64);
        labelMessage.setText(this.message);
        labelMessage.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        int buttonsCompositeColumns = 3;
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite paddingComposite = new Composite(buttonsComposite, 0);
        GridData paddingCompositeGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        paddingCompositeGridData.heightHint = 0;
        paddingComposite.setLayoutData((Object)paddingCompositeGridData);
        this.btnYes = new Button(buttonsComposite, 0);
        GridData button1GridData = new GridData(16384, 1024, false, false, 1, 1);
        button1GridData.widthHint = 80;
        this.btnYes.setLayoutData((Object)button1GridData);
        this.btnYes.setText(Messages.QuestionDialog_yes);
        this.btnYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuestionDialog.this.pressYes();
            }
        });
        this.btnNo = new Button(buttonsComposite, 0);
        GridData button2GridData = new GridData(16384, 1024, false, false, 1, 1);
        button2GridData.widthHint = 80;
        this.btnNo.setLayoutData((Object)button2GridData);
        this.btnNo.setText(Messages.QuestionDialog_no);
        this.btnNo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuestionDialog.this.pressNo();
            }
        });
    }

    @Override
    public final void pressYes() {
        if (this.shell.isDisposed()) {
            throw new UnsupportedOperationException("Dialog is disposed");
        }
        this.result = Boolean.TRUE;
        this.shell.dispose();
        this.notifyListeners();
    }

    @Override
    public final void pressNo() {
        if (this.shell.isDisposed()) {
            throw new UnsupportedOperationException("Dialog is disposed");
        }
        this.result = Boolean.FALSE;
        this.shell.dispose();
        this.notifyListeners();
    }

    private synchronized void notifyListeners() {
        if (this.callback != null) {
            this.callback.committed(this.getResult());
        }
        for (Runnable listener : new ArrayList<Runnable>(this.listeners)) {
            listener.run();
        }
    }

    @Override
    public synchronized void addCloseListener(Runnable runnable) {
        this.listeners.add(runnable);
    }

    @Override
    public final Boolean getResult() {
        return this.result;
    }

    @Override
    public final Shell getShell() {
        return this.shell;
    }
}

