/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import com.ibm.icu.text.DecimalFormat;
import java.text.Format;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.BytesFormat;
import org.eclipse.mat.query.IDecorator;

public final class Column {
    private final String label;
    private final Class<?> type;
    private Alignment align;
    private SortDirection sortDirection;
    private Format formatter;
    private Comparator<?> comparator;
    private IDecorator decorator;
    private boolean calculateTotals = false;
    private Map<Object, Object> data = new HashMap<Object, Object>();
    private static final Map<Class<?>, Format> CLASS2FORMAT = new HashMap();
    private static final Map<Class<?>, Alignment> CLASS2ALIGNMENT = new HashMap();

    static {
        CLASS2FORMAT.put(Integer.class, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Integer.class, Alignment.RIGHT);
        CLASS2FORMAT.put(Integer.TYPE, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Integer.TYPE, Alignment.RIGHT);
        CLASS2FORMAT.put(Long.class, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Long.class, Alignment.RIGHT);
        CLASS2FORMAT.put(Long.TYPE, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Long.TYPE, Alignment.RIGHT);
        CLASS2FORMAT.put(Double.class, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Double.class, Alignment.RIGHT);
        CLASS2FORMAT.put(Double.TYPE, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Double.TYPE, Alignment.RIGHT);
        CLASS2FORMAT.put(Float.class, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Float.class, Alignment.RIGHT);
        CLASS2FORMAT.put(Float.TYPE, (Format)DecimalFormat.getInstance());
        CLASS2ALIGNMENT.put(Float.TYPE, Alignment.RIGHT);
        CLASS2FORMAT.put(Bytes.class, BytesFormat.getInstance());
        CLASS2ALIGNMENT.put(Bytes.class, Alignment.RIGHT);
    }

    public Column(String label) {
        this(label, Object.class);
    }

    public Column(String label, Class<?> type) {
        this.label = label;
        this.type = type;
        this.align = Column.align(type);
        this.formatter = Column.format(type);
        this.calculateTotals = Column.calculateTotals(type);
    }

    public Column(String label, Class<?> type, Alignment align, SortDirection direction, Format formatter, Comparator<?> comparator) {
        this(label, type);
        this.aligning(align);
        this.sorting(direction);
        this.formatting(formatter);
        this.comparing(comparator);
    }

    public Column formatting(Format formatter) {
        this.formatter = formatter;
        return this;
    }

    public Column aligning(Alignment align) {
        this.align = align;
        return this;
    }

    public Column comparing(Comparator<?> comparator) {
        this.comparator = comparator;
        return this;
    }

    public Column sorting(SortDirection direction) {
        this.sortDirection = direction;
        return this;
    }

    public Column noTotals() {
        this.calculateTotals = false;
        return this;
    }

    public Column decorator(IDecorator decorator) {
        this.decorator = decorator;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Alignment getAlign() {
        return this.align;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public String getLabel() {
        return this.label;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public Format getFormatter() {
        return this.formatter;
    }

    public boolean getCalculateTotals() {
        return this.calculateTotals;
    }

    public IDecorator getDecorator() {
        return this.decorator;
    }

    public boolean isNumeric() {
        return this.type.isPrimitive() && !this.type.equals(Character.TYPE) && !this.type.equals(Boolean.TYPE) || Number.class.isAssignableFrom(this.type) || this.type.equals(Bytes.class);
    }

    public Object setData(Object key, Object value) {
        return this.data.put(key, value);
    }

    public Object getData(Object key) {
        return this.data.get(key);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.align, this.calculateTotals, this.formatter, this.label, this.sortDirection, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        return this.align == other.align && this.calculateTotals == other.calculateTotals && Objects.equals(this.formatter, other.formatter) && Objects.equals(this.label, other.label) && this.sortDirection == other.sortDirection && Objects.equals(this.type, other.type);
    }

    private static final Format format(Class<?> type) {
        return CLASS2FORMAT.get(type);
    }

    private static final Alignment align(Class<?> type) {
        Alignment alignment = CLASS2ALIGNMENT.get(type);
        return alignment != null ? alignment : Alignment.LEFT;
    }

    private static boolean calculateTotals(Class<?> type) {
        return CLASS2ALIGNMENT.containsKey(type);
    }

    public static enum Alignment {
        LEFT(16384),
        CENTER(0x1000000),
        RIGHT(131072);

        private int swtCode;

        private Alignment(int swtCode) {
            this.swtCode = swtCode;
        }

        public int getSwtCode() {
            return this.swtCode;
        }
    }

    public static enum SortDirection {
        ASC(128),
        DESC(1024);

        private int swtCode;

        private SortDirection(int swtCode) {
            this.swtCode = swtCode;
        }

        public int getSwtCode() {
            return this.swtCode;
        }

        public static SortDirection of(int swtCode) {
            switch (swtCode) {
                case 128: {
                    return ASC;
                }
                case 1024: {
                    return DESC;
                }
            }
            return null;
        }

        public static SortDirection defaultFor(Column column) {
            return column.isNumeric() ? DESC : ASC;
        }
    }
}

