/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbPluginConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EjbPluginConfiguration.class);
    private static final IProjectFacetVersion DEFAULT_EJB_FACET_VERSION = IJ2EEFacetConstants.EJB_21;
    final Plugin plugin;
    final MavenProject ejbProject;

    public EjbPluginConfiguration(MavenProject mavenProject) {
        if (JEEPackaging.EJB != JEEPackaging.getValue(mavenProject.getPackaging())) {
            throw new IllegalArgumentException(Messages.EjbPluginConfiguration_Project_Must_Have_ejb_Packaging);
        }
        this.ejbProject = mavenProject;
        this.plugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-ejb-plugin");
    }

    public IProjectFacetVersion getEjbFacetVersion() {
        block5: {
            if (this.plugin == null) {
                return DEFAULT_EJB_FACET_VERSION;
            }
            Xpp3Dom dom = (Xpp3Dom)this.plugin.getConfiguration();
            if (dom == null) {
                return DEFAULT_EJB_FACET_VERSION;
            }
            String ejbVersion = DomUtils.getChildValue(dom, "ejbVersion");
            if (ejbVersion != null) {
                try {
                    return WTPProjectsUtil.EJB_FACET.getVersion(ejbVersion);
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage());
                    if (!ejbVersion.startsWith("3.")) break block5;
                    return IJ2EEFacetConstants.EJB_30;
                }
            }
        }
        return DEFAULT_EJB_FACET_VERSION;
    }

    public String getEjbContentDirectory(IProject project) {
        IPath[] resources = MavenProjectUtils.getResourceLocations((IProject)project, (List)this.ejbProject.getResources());
        if (resources != null && resources.length > 0 && resources[0] != null) {
            return resources[0].toPortableString();
        }
        return "src/main/resources";
    }
}

