/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.pde.MavenFeaturePlugin;
import org.eclipse.m2e.pde.TargetBundles;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.feature.AbstractFeatureModel;
import org.eclipse.pde.internal.core.feature.Feature;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

class MavenPomFeatureModel
extends AbstractFeatureModel {
    private static final boolean DEBUG_FEATURE_XML = false;
    private static final long serialVersionUID = 1L;
    private boolean editable;
    private Artifact artifact;
    private TargetBundles targetBundles;
    private boolean isSourceFeature;

    MavenPomFeatureModel(Artifact artifact, TargetBundles bundles, boolean isSourceFeature) {
        this.artifact = artifact;
        this.targetBundles = bundles;
        this.isSourceFeature = isSourceFeature;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void load() throws CoreException {
        this.editable = true;
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream stream = new FileInputStream(this.artifact.getFile());){
                    Model model = MavenPlugin.getMaven().readModel((InputStream)stream);
                    IFeature f = this.getFeature();
                    String id = String.valueOf(model.getGroupId()) + "." + model.getArtifactId() + "." + model.getPackaging();
                    if (this.isSourceFeature) {
                        id = String.valueOf(id) + ".source";
                    }
                    f.setId(id);
                    f.setVersion(TargetBundles.createOSGiVersion(model.getVersion()).toString());
                    String name = model.getName();
                    if (this.isSourceFeature) {
                        name = String.valueOf(name) + " (Source)";
                    }
                    f.setLabel(name);
                    String description = model.getDescription();
                    String url = model.getUrl();
                    IFeatureInfo info = f.getModel().getFactory().createInfo(0);
                    info.setDescription(description);
                    info.setURL(url);
                    f.setFeatureInfo(info, info.getIndex());
                    List licenses = model.getLicenses();
                    if (!licenses.isEmpty()) {
                        licenses.stream().map(license -> Stream.builder().add(license.getName()).add(license.getUrl()).add(license.getComments()).build().filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).collect(Collectors.joining("\r\n"))).collect(Collectors.joining("--------------------------------------------------\r\n"));
                    }
                    Optional<DependencyNode> dependencyNode = this.targetBundles.getDependencyNode(this.artifact);
                    TargetBundle[] dependencies = (TargetBundle[])dependencyNode.map(node -> {
                        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                        node.accept((DependencyVisitor)nlg);
                        return nlg;
                    }).map(nlg -> nlg.getArtifacts(true)).stream().flatMap(Collection::stream).filter(a -> a.getFile() != null).flatMap(a -> this.targetBundles.getTargetBundle((Artifact)a, this.isSourceFeature).stream()).toArray(TargetBundle[]::new);
                    IFeaturePlugin[] featurePlugins = new IFeaturePlugin[dependencies.length];
                    int i = 0;
                    while (i < featurePlugins.length) {
                        MavenFeaturePlugin plugin = new MavenFeaturePlugin(dependencies[i], (IFeatureModel)this);
                        plugin.setParent((IFeatureObject)f);
                        featurePlugins[i] = plugin;
                        ++i;
                    }
                    f.addPlugins(featurePlugins);
                    this.setEnabled(true);
                    this.updateTimeStampWith(System.currentTimeMillis());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "failed to load pom file"));
            }
        }
        finally {
            this.editable = false;
        }
        this.setLoaded(true);
    }

    public String getInstallLocation() {
        return null;
    }

    public boolean isInSync() {
        return true;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected NLResourceHelper createNLResourceHelper() {
        return null;
    }

    public IFeature getFeature() {
        if (this.feature == null) {
            MavenPomFeature f = new MavenPomFeature(this);
            this.feature = f;
        }
        return this.feature;
    }

    private static final class MavenPomFeature
    extends Feature {
        private static final long serialVersionUID = 1L;

        MavenPomFeature(MavenPomFeatureModel model) {
            this.setModel((IFeatureModel)model);
        }

        public boolean isValid() {
            return this.hasRequiredAttributes();
        }
    }
}

