/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSaveReason;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

final class DocumentContentSynchronizer
implements IDocumentListener {
    private final @NonNull LanguageServerWrapper languageServerWrapper;
    private final @NonNull IDocument document;
    private final @NonNull URI fileUri;
    private final TextDocumentSyncKind syncKind;
    private int version = 0;
    private DidChangeTextDocumentParams changeParams;
    private long modificationStamp;
    private final AtomicReference<CompletableFuture<LanguageServer>> lastChangeFuture;
    private LanguageServer languageServer;
    private static final int WILL_SAVE_WAIT_UNTIL_TIMEOUT_IN_SECONDS = 2;
    private static final int WILL_SAVE_WAIT_UNTIL_COUNT_THRESHOLD = 3;
    private static final Map<String, Integer> WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP = new ConcurrentHashMap<String, Integer>();

    public DocumentContentSynchronizer(@NonNull LanguageServerWrapper languageServerWrapper, @NonNull IDocument document, TextDocumentSyncKind syncKind) {
        this.languageServerWrapper = languageServerWrapper;
        this.fileUri = LSPEclipseUtils.toUri(document);
        try {
            IFileStore store = EFS.getStore((URI)this.fileUri);
            this.modificationStamp = store.fetchInfo().getLastModified();
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            this.modificationStamp = new File(this.fileUri).lastModified();
        }
        this.syncKind = syncKind != null ? syncKind : TextDocumentSyncKind.Full;
        this.document = document;
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setUri(this.fileUri.toString());
        textDocument.setText(document.get());
        List<IContentType> contentTypes = LSPEclipseUtils.getDocumentContentTypes(this.document);
        String languageId = languageServerWrapper.getLanguageId(contentTypes.toArray(new IContentType[0]));
        IPath fromPortableString = Path.fromPortableString((String)this.fileUri.getPath());
        if (languageId == null && (languageId = fromPortableString.getFileExtension()) == null) {
            languageId = fromPortableString.lastSegment();
        }
        textDocument.setLanguageId(languageId);
        textDocument.setVersion(++this.version);
        this.lastChangeFuture = new AtomicReference<CompletionStage>(languageServerWrapper.getInitializedServer().thenApplyAsync(ls -> {
            this.languageServer = ls;
            ls.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocument));
            return ls;
        }));
    }

    private <U> @NonNull CompletableFuture<U> executeOnCurrentVersionAsync(Function<LanguageServer, ? extends CompletionStage<U>> fn) {
        AtomicReference resValueFuture = new AtomicReference();
        this.lastChangeFuture.updateAndGet(f -> {
            CompletionStage valueFuture = f.thenComposeAsync(fn);
            resValueFuture.set(valueFuture);
            return ((CompletableFuture)valueFuture).handle((value, error) -> this.languageServer);
        });
        return (CompletableFuture)resValueFuture.get();
    }

    CompletableFuture<LanguageServer> lastChangeFuture() {
        return this.lastChangeFuture.get();
    }

    public void documentChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Full) {
            this.createChangeEvent(event);
        }
        if (this.changeParams != null) {
            DidChangeTextDocumentParams changeParamsToSend = this.changeParams;
            this.changeParams = null;
            changeParamsToSend.getTextDocument().setVersion(Integer.valueOf(++this.version));
            this.lastChangeFuture.updateAndGet(f -> f.thenApplyAsync(ls -> {
                ls.getTextDocumentService().didChange(changeParamsToSend);
                return ls;
            }));
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.checkEvent(event);
        if (this.syncKind == TextDocumentSyncKind.Incremental) {
            this.createChangeEvent(event);
        }
    }

    private boolean createChangeEvent(DocumentEvent event) {
        Assert.isTrue((this.changeParams == null ? 1 : 0) != 0);
        this.changeParams = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(), Collections.singletonList(new TextDocumentContentChangeEvent()));
        this.changeParams.getTextDocument().setUri(this.fileUri.toString());
        IDocument document = event.getDocument();
        TextDocumentContentChangeEvent changeEvent = null;
        TextDocumentSyncKind syncKind = this.getTextDocumentSyncKind();
        switch (syncKind) {
            case None: {
                return false;
            }
            case Full: {
                ((TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0)).setText(event.getDocument().get());
                break;
            }
            case Incremental: {
                changeEvent = (TextDocumentContentChangeEvent)this.changeParams.getContentChanges().get(0);
                String newText = event.getText();
                int offset = event.getOffset();
                int length = event.getLength();
                try {
                    Range range = new Range(LSPEclipseUtils.toPosition(offset, document), LSPEclipseUtils.toPosition(offset + length, document));
                    changeEvent.setRange(range);
                    changeEvent.setText(newText);
                    changeEvent.setRangeLength(Integer.valueOf(length));
                    break;
                }
                catch (BadLocationException e) {
                    changeEvent.setText(document.get());
                }
            }
        }
        return true;
    }

    private boolean serverSupportsWillSaveWaitUntil() {
        Either textDocumentSync;
        ServerCapabilities serverCapabilities = this.languageServerWrapper.getServerCapabilities();
        if (serverCapabilities != null && (textDocumentSync = serverCapabilities.getTextDocumentSync()).isRight()) {
            TextDocumentSyncOptions saveOptions = (TextDocumentSyncOptions)textDocumentSync.getRight();
            return saveOptions != null && saveOptions.getWillSaveWaitUntil() != false;
        }
        return false;
    }

    public void documentAboutToBeSaved() {
        if (!this.serverSupportsWillSaveWaitUntil()) {
            return;
        }
        String uri = this.fileUri.toString();
        if (WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.getOrDefault(uri, 0) > 3) {
            return;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        WillSaveTextDocumentParams params = new WillSaveTextDocumentParams(identifier, TextDocumentSaveReason.Manual);
        List edits = null;
        try {
            edits = (List)this.executeOnCurrentVersionAsync(ls -> ls.getTextDocumentService().willSaveWaitUntil(params)).get(2L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (TimeoutException e) {
            Integer timeoutCount = WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.compute(uri, (k, v) -> v == null ? 1 : Integer.valueOf(v + 1));
            String message = "WillSaveWaitUntil timeouted out after " + Integer.valueOf(2).toString() + " seconds for " + uri;
            if (timeoutCount > 3) {
                message = String.valueOf(message) + ", it will no longer be called for this document";
            }
            LanguageServerPlugin.logWarning(message, e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        try {
            LSPEclipseUtils.applyEdits(this.document, edits);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public void documentSaved(long timestamp) {
        Either textDocumentSync;
        this.modificationStamp = timestamp;
        ServerCapabilities serverCapabilities = this.languageServerWrapper.getServerCapabilities();
        if (serverCapabilities != null && (textDocumentSync = serverCapabilities.getTextDocumentSync()).isRight() && ((TextDocumentSyncOptions)textDocumentSync.getRight()).getSave() == null) {
            return;
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(this.fileUri.toString());
        DidSaveTextDocumentParams params = new DidSaveTextDocumentParams(identifier, this.document.get());
        this.lastChangeFuture.updateAndGet(f -> f.thenApplyAsync(ls -> {
            ls.getTextDocumentService().didSave(params);
            return ls;
        }));
    }

    public void documentClosed() {
        String uri = this.fileUri.toString();
        WILL_SAVE_WAIT_UNTIL_TIMEOUT_MAP.remove(uri);
        if (this.languageServerWrapper.isActive()) {
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
            DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(identifier);
            this.lastChangeFuture.get().thenAcceptAsync(ls -> ls.getTextDocumentService().didClose(params));
        }
    }

    private TextDocumentSyncKind getTextDocumentSyncKind() {
        return this.syncKind;
    }

    protected long getModificationStamp() {
        return this.modificationStamp;
    }

    public IDocument getDocument() {
        return this.document;
    }

    int getVersion() {
        return this.version;
    }

    private void checkEvent(DocumentEvent event) {
        if (this.document != event.getDocument()) {
            throw new IllegalStateException("Synchronizer should apply to only a single document, which is the one it was instantiated for");
        }
    }
}

