/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.InputRestrictedDeque;
import org.eclipse.jpt.common.utility.internal.ArrayTools;

public abstract class AbstractPriorityDeque<E>
implements InputRestrictedDeque<E>,
Cloneable,
Serializable {
    protected final Comparator<? super E> comparator;
    protected transient E[] elements;
    protected int size = 0;
    private static final long serialVersionUID = 1L;

    protected AbstractPriorityDeque(Comparator<? super E> comparator, int initialCapacity) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity + 1];
    }

    @Override
    public void enqueueTail(E element) {
        this.enqueue(element);
    }

    public void enqueue(E element) {
        ++this.size;
        int current = this.size;
        this.elements[current] = element;
        int parent = current >> 1;
        if (parent == 0) {
            return;
        }
        int level = 31 - Integer.numberOfLeadingZeros(current);
        if ((level & 1) == 0) {
            if (this.comparator.compare(this.elements[current], this.elements[parent]) > 0) {
                ArrayTools.swap(this.elements, current, parent);
                current = parent;
                int gp = current >> 2;
                while (gp != 0 && this.comparator.compare(this.elements[current], this.elements[gp]) > 0) {
                    ArrayTools.swap(this.elements, current, gp);
                    current = gp;
                    gp = current >> 2;
                }
            } else {
                int gp = current >> 2;
                while (gp != 0 && this.comparator.compare(this.elements[current], this.elements[gp]) < 0) {
                    ArrayTools.swap(this.elements, current, gp);
                    current = gp;
                    gp = current >> 2;
                }
            }
        } else if (this.comparator.compare(this.elements[current], this.elements[parent]) < 0) {
            ArrayTools.swap(this.elements, current, parent);
            current = parent;
            int gp = current >> 2;
            while (gp != 0 && this.comparator.compare(this.elements[current], this.elements[gp]) < 0) {
                ArrayTools.swap(this.elements, current, gp);
                current = gp;
                gp = current >> 2;
            }
        } else {
            int gp = current >> 2;
            while (gp != 0 && this.comparator.compare(this.elements[current], this.elements[gp]) > 0) {
                ArrayTools.swap(this.elements, current, gp);
                current = gp;
                gp = current >> 2;
            }
        }
    }

    @Override
    public E dequeueHead() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        E element = this.elements[1];
        if (this.size != 1) {
            ArrayTools.swap(this.elements, 1, this.size);
            this.trickleDownMin(1, this.size - 1);
        }
        this.elements[this.size] = null;
        --this.size;
        return element;
    }

    private void trickleDownMin(int index, int newSize) {
        int minChildIndex = index << 1;
        if (minChildIndex > newSize) {
            return;
        }
        E element = this.elements[index];
        E minChild = this.elements[minChildIndex];
        int rightChildIndex = minChildIndex + 1;
        if (rightChildIndex > newSize) {
            if (this.comparator.compare(minChild, element) < 0) {
                ArrayTools.swap(this.elements, minChildIndex, index);
            }
            return;
        }
        E rightChild = this.elements[rightChildIndex];
        if (this.comparator.compare(rightChild, minChild) < 0) {
            minChildIndex = rightChildIndex;
            minChild = rightChild;
        }
        int minGCIndex = -1;
        Object minGC = null;
        int i = index << 2;
        if (i <= newSize) {
            minGCIndex = i;
            minGC = this.elements[i];
            int last = Math.min(i + 3, newSize);
            while (++i <= last) {
                E temp = this.elements[i];
                if (this.comparator.compare(temp, minGC) >= 0) continue;
                minGCIndex = i;
                minGC = temp;
            }
        }
        if (minGC != null && this.comparator.compare(minGC, minChild) < 0) {
            if (this.comparator.compare(minGC, element) < 0) {
                ArrayTools.swap(this.elements, minGCIndex, index);
                int parentIndex = minGCIndex >> 1;
                if (this.comparator.compare(element, this.elements[parentIndex]) > 0) {
                    ArrayTools.swap(this.elements, minGCIndex, parentIndex);
                }
                this.trickleDownMin(minGCIndex, newSize);
            }
        } else if (this.comparator.compare(minChild, element) < 0) {
            ArrayTools.swap(this.elements, minChildIndex, index);
        }
    }

    @Override
    public E dequeueTail() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int index = this.size == 1 ? 1 : (this.size == 2 ? 2 : (this.comparator.compare(this.elements[2], this.elements[3]) > 0 ? 2 : 3));
        E element = this.elements[index];
        if (this.size != 1) {
            ArrayTools.swap(this.elements, index, this.size);
            this.trickleDownMax(index, this.size - 1);
        }
        this.elements[this.size] = null;
        --this.size;
        return element;
    }

    private void trickleDownMax(int index, int newSize) {
        int maxChildIndex = index << 1;
        if (maxChildIndex > newSize) {
            return;
        }
        E element = this.elements[index];
        E maxChild = this.elements[maxChildIndex];
        int rightChildIndex = maxChildIndex + 1;
        if (rightChildIndex > newSize) {
            if (this.comparator.compare(maxChild, element) > 0) {
                ArrayTools.swap(this.elements, maxChildIndex, index);
            }
            return;
        }
        E rightChild = this.elements[rightChildIndex];
        if (this.comparator.compare(rightChild, maxChild) > 0) {
            maxChildIndex = rightChildIndex;
            maxChild = rightChild;
        }
        int maxGCIndex = -1;
        Object maxGC = null;
        int i = index << 2;
        if (i <= newSize) {
            maxGCIndex = i;
            maxGC = this.elements[i];
            int last = Math.min(i + 3, newSize);
            while (++i <= last) {
                E temp = this.elements[i];
                if (this.comparator.compare(temp, maxGC) <= 0) continue;
                maxGCIndex = i;
                maxGC = temp;
            }
        }
        if (maxGC != null && this.comparator.compare(maxGC, maxChild) > 0) {
            if (this.comparator.compare(maxGC, element) > 0) {
                ArrayTools.swap(this.elements, maxGCIndex, index);
                int parentIndex = maxGCIndex >> 1;
                if (this.comparator.compare(element, this.elements[parentIndex]) < 0) {
                    ArrayTools.swap(this.elements, maxGCIndex, parentIndex);
                }
                this.trickleDownMax(maxGCIndex, newSize);
            }
        } else if (this.comparator.compare(maxChild, element) > 0) {
            ArrayTools.swap(this.elements, maxChildIndex, index);
        }
    }

    @Override
    public E peekHead() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[1];
    }

    @Override
    public E peekTail() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        if (this.size == 1) {
            return this.elements[1];
        }
        E left = this.elements[2];
        if (this.size == 2) {
            return left;
        }
        E right = this.elements[3];
        return this.comparator.compare(left, right) > 0 ? left : right;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public AbstractPriorityDeque<E> clone() {
        try {
            AbstractPriorityDeque clone = (AbstractPriorityDeque)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(ArrayTools.subArray(this.elements, 1, this.size + 1));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.elements.length);
        if (this.size == 0) {
            return;
        }
        int i = 1;
        while (i <= this.size) {
            stream.writeObject(this.elements[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 1;
        while (i <= this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
    }
}

