/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.properties.IPropertyProvider;
import org.eclipse.net4j.util.properties.Property;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractPropertyPage<T>
extends PropertyPage {
    private final IPropertyProvider<T> propertyProvider;
    private final String category;
    private final String[] propertyNames;

    public AbstractPropertyPage(IPropertyProvider<T> propertyProvider, String category, String ... propertyNames) {
        assert (propertyProvider != null);
        assert (category != null);
        this.propertyProvider = propertyProvider;
        this.category = category;
        this.propertyNames = propertyNames;
        this.noDefaultAndApplyButton();
    }

    public final T getInput() {
        IAdaptable element = this.getElement();
        return this.convertElement(element);
    }

    protected List<Property<T>> getProperties() {
        return this.propertyProvider.getProperties();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        container.setLayout((Layout)containerGridLayout);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)gridLayout);
        T input = this.getInput();
        this.createContents(composite, input, this.getProperties(), this.propertyNames);
        return container;
    }

    protected void createContents(Composite parent, T input, List<Property<T>> properties, String ... propertyNames) {
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Property<T>> propertiesMap = new HashMap<String, Property<T>>();
        for (Property<T> property : properties) {
            String propertyCategory = property.getCategory();
            if (!this.category.equals(propertyCategory)) continue;
            String name = property.getName();
            names.add(name);
            propertiesMap.put(name, property);
        }
        if (propertyNames.length != 0) {
            String[] stringArray = propertyNames;
            int propertyCategory = propertyNames.length;
            int n = 0;
            while (n < propertyCategory) {
                String name = stringArray[n];
                Property property = (Property)propertiesMap.get(name);
                this.createControl(parent, input, property);
                names.remove(name);
                ++n;
            }
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        names.sort(null);
        for (String name : names) {
            Property property = (Property)propertiesMap.get(name);
            this.createControl(parent, input, property);
        }
    }

    protected Control createControl(Composite parent, T input, Property<T> property) {
        String name = property.getName();
        String label = property.getLabel();
        String description = property.getDescription();
        String value = StringUtil.safe((Object)property.getValue(input));
        Label labelControl = new Label(parent, 0);
        labelControl.setText(String.valueOf(label) + ":");
        Control control = this.createControl(parent, name, description, value);
        if (control == null) {
            control = new Label(parent, 0);
        }
        if (!StringUtil.isEmpty((String)description)) {
            if (StringUtil.isEmpty((String)labelControl.getToolTipText())) {
                labelControl.setToolTipText(description);
            }
            if (StringUtil.isEmpty((String)control.getToolTipText())) {
                control.setToolTipText(description);
            }
        }
        return control;
    }

    protected Control createControl(Composite parent, String name, String description, String value) {
        Label control = new Label(parent, 0);
        control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        control.setText(value);
        return control;
    }

    protected Link createFileLink(Composite parent, String name, String description, String value) {
        File file = new File(value);
        return this.createLink(parent, file.toString(), file.toURI().toString(), uri -> {
            boolean bl = IOUtil.openSystemBrowser((String)uri);
        });
    }

    protected Link createLink(Composite parent, String label, final String uri, final Consumer<String> consumer) {
        Link link = new Link(parent, 0);
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setLinkText(link, label, uri);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(uri);
            }
        });
        return link;
    }

    protected void setLinkText(Link link, String label, String uri) {
        link.setText("<a href=\"" + uri + "\">" + label + "</a>");
    }

    protected abstract T convertElement(IAdaptable var1);
}

