/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoSourceViewer;
import org.eclipse.acceleo.internal.ide.ui.interpreter.ModuleElementNameWizard;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterView;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SaveExpressionAction
extends Action
implements IMenuCreator {
    private AcceleoEditor acceleoEditor;
    private AcceleoSourceViewer acceleoSource;
    private InterpreterView interpreterView;
    private Menu menu;

    public SaveExpressionAction(AcceleoSourceViewer source, InterpreterView interpreterView) {
        super(null, 4);
        this.setMenuCreator(this);
        this.acceleoSource = source;
        this.interpreterView = interpreterView;
    }

    public ImageDescriptor getImageDescriptor() {
        return AcceleoUIActivator.getImageDescriptor("icons/interpreter/save_expression.gif");
    }

    public String getToolTipText() {
        return AcceleoUIMessages.getString("acceleo.interpreter.save.expression");
    }

    public void setCurrentEditor(AcceleoEditor editor) {
        this.acceleoEditor = editor;
    }

    public void run() {
        if (this.acceleoEditor != null) {
            String text = this.acceleoSource.getTextWidget().getText();
            if (!text.contains("[template") && !text.contains("[query")) {
                String expression = this.acceleoSource.computeTemplateFromContext(this.interpreterView.getInterpreterContext(), null);
                int templateIndex = expression.indexOf("[template public temporaryInterpreterTemplate");
                if (templateIndex != -1) {
                    expression = expression.substring(templateIndex);
                }
                text = expression;
            }
            IDocument document = this.acceleoEditor.getDocumentProvider().getDocument((Object)this.acceleoEditor.getEditorInput());
            String newText = document.get();
            newText = String.valueOf(newText) + AcceleoSourceViewer.LINE_SEPARATOR + text + AcceleoSourceViewer.LINE_SEPARATOR;
            document.set(newText);
        } else {
            String expression = this.acceleoSource.rebuildFullExpression(this.interpreterView.getInterpreterContext());
            this.saveContentInNewFile(expression);
        }
    }

    private void saveContentInNewFile(String content) {
        String fileContent = content;
        AcceleoModulesViewerFilter viewerFilter = new AcceleoModulesViewerFilter();
        ArrayList<AcceleoModulesViewerFilter> viewerFilters = new ArrayList<AcceleoModulesViewerFilter>();
        viewerFilters.add(viewerFilter);
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.acceleoSource.getControl().getShell(), (String)AcceleoUIMessages.getString("acceleo.interpreter.load.module.path.title"), (String)AcceleoUIMessages.getString("acceleo.interpreter.load.module.path"), (boolean)false, null, viewerFilters);
        if (files != null && files.length == 1) {
            try {
                IFile iFile = files[0];
                StringBuffer fileBufferedContent = FileContent.getFileContent((File)iFile.getLocation().toFile());
                int indexOfTemplate = fileContent.indexOf("[template");
                int indexOfQuery = fileContent.indexOf("[query");
                int indexOfModuleElement = Math.min(indexOfTemplate, indexOfQuery);
                if (indexOfTemplate == -1) {
                    indexOfModuleElement = indexOfQuery;
                } else if (indexOfQuery == -1) {
                    indexOfModuleElement = indexOfTemplate;
                }
                fileContent = fileContent.substring(indexOfModuleElement);
                fileBufferedContent.append(System.getProperty("line.separator"));
                fileBufferedContent.append(fileContent);
                iFile.setContents((InputStream)new ByteArrayInputStream(fileBufferedContent.toString().getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)iFile);
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    private void computeMTLFiles(List<IFile> files, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && container.isAccessible() && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    files.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.computeMTLFiles(files, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this.acceleoEditor = null;
        this.acceleoSource = null;
        this.interpreterView = null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.addActionToMenu(this.menu, new SaveAsTemplateAction());
        this.addActionToMenu(this.menu, new SaveAsQueryAction());
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.addActionToMenu(this.menu, new SaveAsTemplateAction());
        this.addActionToMenu(this.menu, new SaveAsQueryAction());
        return this.menu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private final class AcceleoModulesViewerFilter
    extends ViewerFilter {
        private AcceleoModulesViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            ArrayList files = new ArrayList();
            try {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        AcceleoProject acceleoProject = new AcceleoProject(project);
                        result = acceleoProject.getInputFiles().size() > 0;
                    }
                } else if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    IProject project = container.getProject();
                    if (project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        AcceleoProject acceleoProject = new AcceleoProject(project);
                        List<IPath> sourceFolders = acceleoProject.getSourceFolders();
                        boolean shouldVisit = false;
                        for (IPath iPath : sourceFolders) {
                            if (container.getLocation().toString().startsWith(ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath).getLocation().toString())) {
                                SaveExpressionAction.this.computeMTLFiles(files, container);
                                boolean bl = shouldVisit = files.size() > 0;
                            }
                            if (shouldVisit) break;
                        }
                        result = shouldVisit;
                    }
                } else if (element instanceof IFile && "mtl".equals(((IFile)element).getFileExtension())) {
                    result = true;
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
            return result;
        }
    }

    private class SaveAsQueryAction
    extends Action {
        private SaveAsQueryAction() {
        }

        public String getText() {
            return AcceleoUIMessages.getString("acceleo.interpreter.save.as.query");
        }

        public ImageDescriptor getImageDescriptor() {
            return AcceleoUIActivator.getImageDescriptor("icons/template-editor/Query.gif");
        }

        public void run() {
            String queryName = "";
            ModuleElementNameWizard wizard = new ModuleElementNameWizard(AcceleoUIMessages.getString("acceleo.interpreter.save.as.query.title"), AcceleoUIMessages.getString("acceleo.interpreter.save.as.query.description"), AcceleoUIMessages.getString("acceleo.interpreter.save.as.query.label"));
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            queryName = wizard.getModuleElementName();
            String expression = SaveExpressionAction.this.acceleoSource.computeQueryFromContext(SaveExpressionAction.this.interpreterView.getInterpreterContext(), queryName);
            if (SaveExpressionAction.this.acceleoEditor != null) {
                String text = SaveExpressionAction.this.acceleoSource.getTextWidget().getText();
                ISelection selection = SaveExpressionAction.this.acceleoSource.getSelection();
                if ((selection == null || !(selection instanceof TextSelection) || ((TextSelection)selection).getLength() != 0) && selection != null && selection instanceof TextSelection) {
                    text = ((TextSelection)selection).getText();
                }
                if (!text.contains("[query")) {
                    int queryIndex = expression.indexOf("[query public " + queryName);
                    if (queryIndex != -1) {
                        expression = expression.substring(queryIndex);
                    }
                    text = expression;
                }
                IDocument document = SaveExpressionAction.this.acceleoEditor.getDocumentProvider().getDocument((Object)SaveExpressionAction.this.acceleoEditor.getEditorInput());
                String newText = document.get();
                newText = String.valueOf(newText) + AcceleoSourceViewer.LINE_SEPARATOR + text + AcceleoSourceViewer.LINE_SEPARATOR;
                document.set(newText);
            } else {
                SaveExpressionAction.this.saveContentInNewFile(expression);
            }
        }
    }

    private class SaveAsTemplateAction
    extends Action {
        private SaveAsTemplateAction() {
        }

        public String getText() {
            return AcceleoUIMessages.getString("acceleo.interpreter.save.as.template");
        }

        public ImageDescriptor getImageDescriptor() {
            return AcceleoUIActivator.getImageDescriptor("icons/template-editor/Template.gif");
        }

        public void run() {
            String templateName = "";
            ModuleElementNameWizard wizard = new ModuleElementNameWizard(AcceleoUIMessages.getString("acceleo.interpreter.save.as.template.title"), AcceleoUIMessages.getString("acceleo.interpreter.save.as.template.description"), AcceleoUIMessages.getString("acceleo.interpreter.save.as.template.label"));
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            templateName = wizard.getModuleElementName();
            String expression = SaveExpressionAction.this.acceleoSource.computeTemplateFromContext(SaveExpressionAction.this.interpreterView.getInterpreterContext(), templateName);
            if (SaveExpressionAction.this.acceleoEditor != null) {
                String text = SaveExpressionAction.this.acceleoSource.getTextWidget().getText();
                if (!text.contains("[template")) {
                    int templateIndex = expression.indexOf("[template public " + templateName);
                    if (templateIndex != -1) {
                        expression = expression.substring(templateIndex);
                    }
                    text = expression;
                }
                IDocument document = SaveExpressionAction.this.acceleoEditor.getDocumentProvider().getDocument((Object)SaveExpressionAction.this.acceleoEditor.getEditorInput());
                String newText = document.get();
                newText = String.valueOf(newText) + AcceleoSourceViewer.LINE_SEPARATOR + text + AcceleoSourceViewer.LINE_SEPARATOR;
                document.set(newText);
            } else {
                SaveExpressionAction.this.saveContentInNewFile(expression);
            }
        }
    }
}

