/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.XtextSwitch;

public class CurrentTypeFinder {
    public EClassifier findCurrentTypeAfter(AbstractElement element) {
        AbstractRule rule = GrammarUtil.containingRule(element);
        Implementation implementation = new Implementation();
        implementation.computeResult(rule, element);
        return implementation.getResult();
    }

    public static class Implementation
    extends XtextSwitch<Boolean> {
        private EClassifier currentType;
        private AbstractRule context;
        private AbstractElement stopElement;
        private Set<AbstractRule> visiting = Sets.newHashSet();

        public EClassifier getResult() {
            return this.currentType;
        }

        public void computeResult(AbstractRule rule, AbstractElement element) {
            this.context = rule;
            this.stopElement = element;
            this.doSwitch(rule);
        }

        @Override
        public Boolean caseAbstractElement(AbstractElement object) {
            return object == this.stopElement;
        }

        @Override
        public Boolean caseAction(Action object) {
            if (object.getType() != null) {
                this.currentType = object.getType().getClassifier();
            }
            return object == this.stopElement;
        }

        @Override
        public Boolean caseParserRule(ParserRule object) {
            if (this.visiting.add(object)) {
                try {
                    if (object.getAlternatives() != null) {
                        Boolean bl = (Boolean)this.doSwitch(object.getAlternatives());
                        return bl;
                    }
                }
                finally {
                    this.visiting.remove(object);
                }
            }
            return true;
        }

        @Override
        public Boolean caseAssignment(Assignment object) {
            EClassifier wasType = this.currentType;
            if (this.currentType == null && this.context.getType() != null) {
                this.currentType = this.context.getType().getClassifier();
            }
            if (object.getTerminal() != null && ((Boolean)this.doSwitch(object.getTerminal())).booleanValue()) {
                return true;
            }
            if (object == this.stopElement) {
                return true;
            }
            if (GrammarUtil.isOptionalCardinality(object)) {
                this.currentType = this.getCompatibleType(this.currentType, wasType, object);
            }
            return false;
        }

        @Override
        public Boolean caseCompoundElement(CompoundElement object) {
            EClassifier wasType = this.currentType;
            for (AbstractElement element : object.getElements()) {
                if (!((Boolean)this.doSwitch(element)).booleanValue()) continue;
                return true;
            }
            if (object == this.stopElement) {
                return true;
            }
            if (GrammarUtil.isOptionalCardinality(object)) {
                this.currentType = this.getCompatibleType(this.currentType, wasType, object);
            }
            return false;
        }

        @Override
        public Boolean caseCrossReference(CrossReference object) {
            if (object == this.stopElement) {
                return true;
            }
            return (Boolean)this.doSwitch(object.getTerminal());
        }

        @Override
        public Boolean caseRuleCall(RuleCall object) {
            EClassifier wasType = this.currentType;
            AbstractRule calledRule = object.getRule();
            if (this.currentType == null) {
                if (calledRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)calledRule)) {
                    ParserRule parserRule = (ParserRule)calledRule;
                    if (parserRule.isFragment()) {
                        if (this.context.getType() != null) {
                            this.currentType = this.context.getType().getClassifier();
                        }
                        if (!parserRule.isWildcard()) {
                            this.doSwitch(parserRule);
                        }
                    } else {
                        TypeRef returnType = calledRule.getType();
                        if (returnType != null) {
                            this.currentType = returnType.getClassifier();
                        }
                    }
                }
            } else if (this.isFragmentButNotWildcard(calledRule)) {
                this.doSwitch(calledRule);
            }
            if (object == this.stopElement) {
                return true;
            }
            if (GrammarUtil.isOptionalCardinality(object)) {
                this.currentType = this.getCompatibleType(this.currentType, wasType, object);
            }
            return false;
        }

        private boolean isFragmentButNotWildcard(AbstractRule calledRule) {
            if (calledRule instanceof ParserRule) {
                ParserRule casted = (ParserRule)calledRule;
                return casted.isFragment() && !casted.isWildcard();
            }
            return false;
        }

        protected EClassifier getCompatibleType(EClassifier a, EClassifier b, EObject context) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return EcoreUtil2.getCompatibleType(a, b, context);
        }

        @Override
        public Boolean caseAlternatives(Alternatives object) {
            EClassifier wasType = this.currentType;
            List alternativeTypes = null;
            for (AbstractElement element : object.getElements()) {
                this.currentType = wasType;
                if (((Boolean)this.doSwitch(element)).booleanValue()) {
                    return true;
                }
                if (this.currentType == wasType) continue;
                if (alternativeTypes != null) {
                    alternativeTypes.add(this.currentType);
                    continue;
                }
                alternativeTypes = Lists.newArrayList((Object[])new EClassifier[]{this.currentType});
            }
            if (alternativeTypes != null) {
                if (alternativeTypes.size() != object.getElements().size()) {
                    alternativeTypes.add(wasType);
                }
                this.currentType = null;
                for (EClassifier classifier : alternativeTypes) {
                    this.currentType = this.getCompatibleType(this.currentType, classifier, object);
                }
            }
            if (object == this.stopElement) {
                return true;
            }
            if (GrammarUtil.isOptionalCardinality(object)) {
                this.currentType = this.getCompatibleType(this.currentType, wasType, object);
            }
            return false;
        }
    }
}

