/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.build;

import com.google.common.annotations.Beta;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationAdapter;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.junit4.util.InMemoryURIHandler;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Before;

@Deprecated
@Beta
public abstract class AbstractIncrementalBuilderTest {
    @Inject
    protected IncrementalBuilder incrementalBuilder;
    @Inject
    protected IndexState indexState;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private OutputConfigurationProvider configurationProvider;
    protected Multimap<URI, URI> generated;
    protected List<URI> deleted;
    protected List<Issue> issues;
    protected InMemoryURIHandler inMemoryURIHandler;

    @Before
    public void setUp() {
        this.clean();
        this.inMemoryURIHandler = new InMemoryURIHandler();
    }

    protected List<Issue> clean() {
        ArrayList<Issue> result = null;
        this.generated = ArrayListMultimap.create();
        this.deleted = new ArrayList<URI>();
        this.issues = new ArrayList<Issue>();
        result = this.issues;
        return result;
    }

    protected IndexState build(BuildRequest buildRequest) {
        this.clean();
        this.indexState = this.incrementalBuilder.build(buildRequest, it -> this.getLanguages().getResourceServiceProvider(it)).getIndexState();
        return this.indexState;
    }

    protected void withOutputConfig(BuildRequest it, Procedures.Procedure1<? super OutputConfiguration> init) {
        OutputConfiguration config = (OutputConfiguration)Iterables.getFirst((Iterable)this.configurationProvider.getOutputConfigurations(), null);
        init.apply((Object)config);
        OutputConfigurationAdapter adapter = new OutputConfigurationAdapter(Collections.singletonMap(this.languageName, Collections.singleton(config)));
        it.getResourceSet().eAdapters().add((Object)adapter);
    }

    protected abstract IResourceServiceProvider.Registry getLanguages();

    protected BuildRequest newBuildRequest(Procedures.Procedure1<? super BuildRequest> init) {
        BuildRequest result = new BuildRequest();
        ResourceDescriptionsData newIndex = this.indexState.getResourceDescriptions().copy();
        result.setBaseDir(this.uri(""));
        XtextResourceSet rs = (XtextResourceSet)this.resourceSetProvider.get();
        rs.getURIConverter().getURIHandlers().clear();
        rs.getURIConverter().getURIHandlers().add((Object)this.inMemoryURIHandler);
        rs.setClasspathURIContext((Object)AbstractIncrementalBuilderTest.class.getClassLoader());
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName("test-project");
        projectDescription.attachToEmfObject((Notifier)rs);
        ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(Collections.emptyMap(), (ResourceSet)rs);
        index.setContainer(projectDescription.getName(), newIndex);
        result.setResourceSet(rs);
        result.setDirtyFiles(Collections.emptyList());
        result.setDeletedFiles(Collections.emptyList());
        result.setAfterValidate((uri, issues) -> {
            Iterables.addAll(this.issues, (Iterable)issues);
            return IterableExtensions.isEmpty((Iterable)issues);
        });
        result.setAfterDeleteFile(uri -> {
            boolean bl = this.deleted.add((URI)uri);
        });
        result.setAfterGenerateFile((source, target) -> {
            boolean bl = this.generated.put(source, target);
        });
        result.setState(new IndexState(newIndex, this.indexState.getFileMappings().copy()));
        init.apply((Object)result);
        return result;
    }

    protected URI delete(URI uri) {
        try {
            this.inMemoryURIHandler.delete(uri, Collections.emptyMap());
            return uri;
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected URI uri(String path) {
        return URI.createURI((String)("inmemory:/" + path));
    }

    protected URI operator_minus(String path, String content) {
        try {
            URI uri = this.uri(path);
            OutputStream outputStream = this.inMemoryURIHandler.createOutputStream(uri, Collections.emptyMap());
            try {
                outputStream.write(content.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
            return uri;
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected boolean containsSuffix(Iterable<? extends URI> uris, String ... suffixes) {
        Iterable iterable = (Iterable)Conversions.doWrapArray((Object)suffixes);
        return IterableExtensions.forall((Iterable)iterable, suffix -> IterableExtensions.exists((Iterable)uris, uri -> uri.toString().endsWith((String)suffix)));
    }
}

