/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

class NameCollector
extends GenericVisitor {
    private List names = new ArrayList();
    private Selection fSelection;

    public NameCollector(ASTNode node) {
        this.fSelection = Selection.createFromStartLength(node.getStartPosition(), node.getLength());
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (node.getStartPosition() > this.fSelection.getInclusiveEnd()) {
            return true;
        }
        return this.fSelection.coveredBy(node);
    }

    @Override
    public boolean visit(SimpleName node) {
        this.names.add(node.getIdentifier());
        return super.visit(node);
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        boolean result = super.visit(node);
        if (!result) {
            this.names.add(node.getName().getIdentifier());
        }
        return result;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        boolean result = super.visit(node);
        if (!result) {
            this.names.add(node.getName().getIdentifier());
        }
        return result;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        this.names.add(node.getDeclaration().getName().getIdentifier());
        return false;
    }

    List getNames() {
        return this.names;
    }
}

