/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.ImageImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public final class BundleResourceProvider {
    private static final Map<String, BundleResourceProvider> m_providers = Maps.newHashMap();
    private final String m_id;
    private final Bundle m_bundle;
    private final Map<String, Image> m_pathToImage = Maps.newTreeMap();
    private final Map<String, ImageDescriptor> m_pathToImageDescriptor = Maps.newTreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleResourceProvider get(String id) {
        Map<String, BundleResourceProvider> map = m_providers;
        synchronized (map) {
            BundleResourceProvider provider = m_providers.get(id);
            if (provider == null) {
                provider = new BundleResourceProvider(id);
                m_providers.put(id, provider);
            }
            return provider;
        }
    }

    public static BundleResourceProvider get(Bundle bundle) {
        String id = bundle.getSymbolicName();
        return BundleResourceProvider.get(id);
    }

    public static void configureCleanUp(BundleContext context) {
        context.addBundleListener(new BundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 16) {
                    BundleResourceProvider provider;
                    Map map = m_providers;
                    synchronized (map) {
                        String id = event.getBundle().getSymbolicName();
                        provider = (BundleResourceProvider)m_providers.remove(id);
                    }
                    if (provider != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                provider.disposeImages();
                            }
                        });
                    }
                }
            }
        });
    }

    private BundleResourceProvider(String id) {
        this.m_id = id;
        this.m_bundle = Platform.getBundle((String)id);
        Assert.isNotNull(this.m_bundle, "Unable for find bundle %s", id);
    }

    public String getFileString(final String path) {
        return ExecutionUtils.runObject(new RunnableObjectEx<String>(){

            @Override
            public String runObject() throws Exception {
                InputStream inputStream = BundleResourceProvider.this.getFile(path);
                return IOUtils2.readString(inputStream);
            }
        });
    }

    public InputStream getFile(String path) {
        path = BundleResourceProvider.normalizePath(path);
        return this.getFile0(path);
    }

    private InputStream getFile0(final String path) {
        return ExecutionUtils.runObject(new RunnableObjectEx<InputStream>(){

            @Override
            public InputStream runObject() throws Exception {
                return BundleResourceProvider.this.m_bundle.getEntry(path).openStream();
            }
        }, "Unable to open file %s from %s", path, this.m_id);
    }

    private static String normalizePath(String path) {
        while (path.indexOf("//") != -1) {
            path = StringUtils.replace((String)path, (String)"//", (String)"/");
        }
        if (path.length() != 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    public Image getImage(String path) {
        Image image = this.m_pathToImage.get(path = BundleResourceProvider.normalizePath(path));
        if (image == null) {
            InputStream is = this.getFile(path);
            try {
                image = new Image((Device)Display.getCurrent(), is);
                this.m_pathToImage.put(path, image);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = this.m_pathToImageDescriptor.get(path = BundleResourceProvider.normalizePath(path));
        if (descriptor == null) {
            Image image = this.getImage(path);
            descriptor = new ImageImageDescriptor(image);
            this.m_pathToImageDescriptor.put(path, descriptor);
        }
        return descriptor;
    }

    private void disposeImages() {
        for (Image image : this.m_pathToImage.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }
}

