/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class TmfCoreTracer {
    private static final String PLUGIN_ID = "org.eclipse.tracecompass.tmf.core";
    private static final String COMPONENT_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/component";
    private static final String REQUEST_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/request";
    private static final String SIGNAL_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/signal";
    private static final String EVENT_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/event";
    private static final String ANALYSIS_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/analysis";
    private static final String INDEXER_TRACE_KEY = "org.eclipse.tracecompass.tmf.core/indexer";
    private static final String TRACE_FILE_NAME = "TmfTrace.log";
    private static volatile boolean fComponentClassEnabled = false;
    private static volatile boolean fRequestClassEnabled = false;
    private static volatile boolean fSignalClassEnabled = false;
    private static volatile boolean fEventClassEnabled = false;
    private static volatile boolean fAnalysisClassEnabled = false;
    private static volatile boolean fIndexerClassEnabled = false;
    private static BufferedWriter fTraceFile;

    private TmfCoreTracer() {
    }

    public static synchronized void init() {
        boolean isTracing = false;
        String traceKey = Platform.getDebugOption((String)COMPONENT_TRACE_KEY);
        if (traceKey != null) {
            fComponentClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fComponentClassEnabled;
        }
        if ((traceKey = Platform.getDebugOption((String)REQUEST_TRACE_KEY)) != null) {
            fRequestClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fRequestClassEnabled;
        }
        if ((traceKey = Platform.getDebugOption((String)SIGNAL_TRACE_KEY)) != null) {
            fSignalClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fSignalClassEnabled;
        }
        if ((traceKey = Platform.getDebugOption((String)EVENT_TRACE_KEY)) != null) {
            fEventClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fEventClassEnabled;
        }
        if ((traceKey = Platform.getDebugOption((String)ANALYSIS_TRACE_KEY)) != null) {
            fAnalysisClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fAnalysisClassEnabled;
        }
        if ((traceKey = Platform.getDebugOption((String)INDEXER_TRACE_KEY)) != null) {
            fIndexerClassEnabled = Boolean.parseBoolean(traceKey);
            isTracing |= fIndexerClassEnabled;
        }
        if (isTracing) {
            try {
                fTraceFile = new BufferedWriter(new FileWriter(TRACE_FILE_NAME));
            }
            catch (IOException e) {
                Activator.logError("Error opening log file TmfTrace.log", e);
                fTraceFile = null;
            }
        }
    }

    public static synchronized void stop() {
        if (fTraceFile != null) {
            try {
                fTraceFile.close();
                fTraceFile = null;
            }
            catch (IOException e) {
                Activator.logError("Error closing log file", e);
            }
        }
    }

    public static boolean isComponentTraced() {
        return fComponentClassEnabled;
    }

    public static boolean isRequestTraced() {
        return fRequestClassEnabled;
    }

    public static boolean isSignalTraced() {
        return fSignalClassEnabled;
    }

    public static boolean isEventTraced() {
        return fEventClassEnabled;
    }

    public static boolean isAnalysisTraced() {
        return fAnalysisClassEnabled;
    }

    public static boolean isIndexerTraced() {
        return fAnalysisClassEnabled;
    }

    public static synchronized void trace(String msg) {
        if (fTraceFile == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append("[TID=");
        message.append(String.format("%1$03d", Thread.currentThread().getId()));
        message.append("] ");
        message.append(msg);
        System.out.println(message);
        try {
            fTraceFile.write(message.toString());
            fTraceFile.newLine();
            fTraceFile.flush();
        }
        catch (IOException e) {
            Activator.logError("Error writing to log file", e);
        }
    }

    public static void traceComponent(String componentName, String msg) {
        if (fComponentClassEnabled) {
            String message = "[CMP] Cmp=" + componentName + " " + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceRequest(int requestId, String msg) {
        if (fRequestClassEnabled) {
            String message = "[REQ] Req=" + requestId + " " + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceIndexer(String msg) {
        if (fIndexerClassEnabled) {
            String message = "[INDEXER] " + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceSignal(TmfSignal signal, String msg) {
        if (fSignalClassEnabled) {
            String message = "[SIG] Sig=" + signal.getClass().getSimpleName() + " Target=" + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceEvent(ITmfEventProvider provider, ITmfEventRequest request, ITmfEvent event) {
        if (fEventClassEnabled) {
            String message = "[EVT] Provider=" + provider.toString() + ", Req=" + request.getRequestId() + ", Event=" + event.getTimestamp();
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceAnalysis(String analysisId, ITmfTrace trace, String msg) {
        if (fAnalysisClassEnabled) {
            String traceName = trace == null ? "" : trace.getName();
            String message = "[ANL] Anl=" + analysisId + " for " + traceName + " " + msg;
            TmfCoreTracer.trace(message);
        }
    }
}

