/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreate;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCreateFolder
extends OpCreate {
    public OpCreateFolder(FSTreeNode folder, String name) {
        super(folder, name);
    }

    @Override
    protected void tcfCreate(final FSTreeNode destination, final String name, final TCFOperationMonitor<FSTreeNode> result) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (result.checkCancelled()) {
            return;
        }
        final String path = this.getPath(destination, name);
        final IFileSystem fileSystem = destination.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        fileSystem.mkdir(path, null, new IFileSystem.DoneMkDir(){

            public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(StatusHelper.createStatus(MessageFormat.format(Messages.OpCreateFolder_error_createFolder, path), (Throwable)error));
                } else if (!result.checkCancelled()) {
                    fileSystem.stat(path, new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                            if (error != null) {
                                result.setError(StatusHelper.createStatus(MessageFormat.format(Messages.OpCreateFolder_error_createFolder, path), (Throwable)error));
                            } else if (!result.checkCancelled()) {
                                FSTreeNode node = new FSTreeNode(destination, name, false, attrs);
                                node.setContent(new FSTreeNode[0], false);
                                destination.addNode(node, true);
                                result.setDone((Object)node);
                            }
                        }
                    });
                }
            }
        });
    }
}

