/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectParameter;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectMethod
extends ReflectItem
implements JNIMethod {
    Method method;
    ReflectType returnType;
    ReflectType[] paramTypes;
    ReflectClass declaringClass;
    Boolean unique;

    public ReflectMethod(ReflectClass declaringClass, Method method) {
        this.method = method;
        this.declaringClass = declaringClass;
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        this.returnType = new ReflectType(returnType);
        this.paramTypes = new ReflectType[paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            this.paramTypes[i] = new ReflectType(paramTypes[i]);
            ++i;
        }
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectMethod)) {
            return false;
        }
        return ((ReflectMethod)obj).method.equals(this.method);
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isNativeUnique() {
        if (this.unique != null) {
            return this.unique;
        }
        boolean result = true;
        String name = this.getName();
        JNIMethod[] jNIMethodArray = this.declaringClass.getDeclaredMethods();
        int n = jNIMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod mth = jNIMethodArray[n2];
            if ((mth.getModifiers() & 0x100) != 0 && this != mth && !this.equals(mth) && name.equals(mth.getName())) {
                result = false;
                break;
            }
            ++n2;
        }
        this.unique = result;
        return result;
    }

    @Override
    public JNIType[] getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public JNIParameter[] getParameters() {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        JNIParameter[] result = new ReflectParameter[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            result[i] = new ReflectParameter(this, i);
            ++i;
        }
        return result;
    }

    @Override
    public JNIType getReturnType() {
        return this.returnType;
    }

    @Override
    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        MetaData metaData = this.declaringClass.metaData;
        String className = this.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this);
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = String.valueOf(className) + "_" + this.method.getName();
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            JNIType[] paramTypes = this.getParameterTypes();
            if (ReflectMethod.convertTo32Bit(paramTypes, true)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this, paramTypes);
                value = metaData.getMetaData(key, null);
            }
            if (value == null && ReflectMethod.convertTo32Bit(paramTypes = this.getParameterTypes(), false)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this, paramTypes);
                value = metaData.getMetaData(key, null);
            }
        }
        if (value == null && this.method.getName().startsWith("_") && (value = metaData.getMetaData(key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this).substring(2), null)) == null) {
            key = String.valueOf(className) + "_" + this.method.getName().substring(1);
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        String className = this.declaringClass.getSimpleName();
        String key = this.isNativeUnique() ? String.valueOf(className) + "_" + this.method.getName() : String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this);
        this.declaringClass.metaData.setMetaData(key, value);
    }

    public String toString() {
        return this.method.toString();
    }
}

