/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.tools.internal.Messages;

public class TreeItemMappingExpression {
    private static final String TREE = "tree";
    private GlobalContext ctx;
    private TreeItemMapping mapping;

    public TreeItemMappingExpression(GlobalContext ctx, TreeItemMapping mapping) {
        this.ctx = ctx;
        this.mapping = mapping;
    }

    public boolean checkPrecondition(EObject semantic, DTreeItemContainer containerView) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        IInterpreter interpreter = this.ctx.getInterpreter();
        boolean result = true;
        if (!StringUtil.isEmpty((String)this.mapping.getPreconditionExpression())) {
            interpreter.setVariable("containerView", (Object)containerView);
            interpreter.setVariable("container", (Object)containerView.getTarget());
            interpreter.setVariable(TREE, (Object)TreeHelper.getTree((EObject)containerView));
            try {
                result = interpreter.evaluateBoolean(semantic, this.mapping.getPreconditionExpression());
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.TreeItemMappingExpression_preconditionEvaluationError, this.mapping.getPreconditionExpression()), (Exception)((Object)e));
            }
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable(TREE);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.CHECK_PRECONDITION_KEY);
        return result;
    }
}

