/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SnapChangeBoundsRequest;
import org.eclipse.swt.events.KeyEvent;

public class SiriusResizeTracker
extends ResizeTracker {
    public static final String CHILDREN_MOVE_MODE_KEY = "keepSameAbsoluteLocation";
    public static final boolean DEFAULT_CHILDREN_MOVE_MODE = true;
    protected static final int CHILDREN_MOVE_MODE_SHORTCUT_KEY = 0x100000C;
    boolean childrenMoveMode = true;
    boolean snapToAllShape = false;

    public SiriusResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected Request createSourceRequest() {
        SnapChangeBoundsRequest request = new SnapChangeBoundsRequest("resize");
        request.setResizeDirection(this.getResizeDirection());
        return request;
    }

    protected boolean handleKeyDown(KeyEvent event) {
        boolean keyHandled = false;
        if (0x100000C == event.keyCode) {
            this.childrenMoveMode = false;
            keyHandled = true;
        } else if (0x100000D == event.keyCode) {
            this.snapToAllShape = true;
            keyHandled = true;
        }
        if (keyHandled) {
            return keyHandled;
        }
        return super.handleKeyDown(event);
    }

    protected boolean handleKeyUp(KeyEvent event) {
        boolean keyHandled = false;
        if (0x100000C == event.keyCode) {
            this.childrenMoveMode = true;
            keyHandled = true;
        } else if (0x100000D == event.keyCode) {
            this.snapToAllShape = false;
            keyHandled = true;
        }
        if (keyHandled) {
            return keyHandled;
        }
        return super.handleKeyUp(event);
    }

    protected void updateSourceRequest() {
        if (this.getSourceRequest() instanceof SnapChangeBoundsRequest) {
            if (this.snapToAllShape) {
                ((SnapChangeBoundsRequest)this.getSourceRequest()).setSnapToAllShape(true);
            } else {
                ((SnapChangeBoundsRequest)this.getSourceRequest()).setSnapToAllShape(false);
            }
        }
        super.updateSourceRequest();
        if (this.childrenMoveMode) {
            this.getSourceRequest().getExtendedData().put(CHILDREN_MOVE_MODE_KEY, Boolean.TRUE);
        } else {
            this.getSourceRequest().getExtendedData().put(CHILDREN_MOVE_MODE_KEY, Boolean.FALSE);
        }
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.childrenMoveMode = true;
        this.snapToAllShape = false;
        return result;
    }
}

