/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.zephyr.TestCaseResultModel;
import org.eclipse.rcptt.internal.zephyr.ZephyrConfigModel;
import org.eclipse.rcptt.internal.zephyr.ZephyrPlugin;

public final class ZephyrTestCase {
    public static final int PASS = 1;
    public static final int FAIL = 2;
    private static final int MAX_ISSUE_SEARCH_COUNT = 250;
    private static final String URL_GET_ALL_TESTS = "%s/rest/api/2/search?%sjql=project=%s&issuetype=%s&maxResults=250&startAt=%s";
    private static final String URL_CREATE_EXECUTIONS_URL = "%s/rest/zapi/latest/execution?projectId=%s&versionId=%s&cycleId=%s";
    private static final String URL_EXECUTE_TEST = "%s/rest/zapi/latest/execution/%s/execute";

    public static Long getTestCaseId(ZephyrConfigModel zephyrData) {
        String issueName = zephyrData.getIssueName();
        if (issueName == null) {
            return null;
        }
        Map<String, Long> searchedTests = ZephyrTestCase.searchIssues(zephyrData);
        return searchedTests.get(issueName);
    }

    private static Map<Long, Long> fetchExecutionIds(ZephyrConfigModel zephyrData) {
        HashMap<Long, Long> issueKeyExecutionIdMap;
        block15: {
            issueKeyExecutionIdMap = new HashMap<Long, Long>();
            String url = String.format(URL_CREATE_EXECUTIONS_URL, zephyrData.getRestClient().getUrl(), zephyrData.getProjectId(), zephyrData.getVersionId(), zephyrData.getCycleId());
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (CloseableHttpResponse response = zephyrData.getRestClient().get(url);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(String.format("Bad response entity upon receipt of execution ids <%s>", url), e);
                        }
                        JsonObject executionObject = new JsonParser().parse(string).getAsJsonObject();
                        JsonArray executions = executionObject.get("executions").getAsJsonArray();
                        int i = 0;
                        while (i < executions.size()) {
                            JsonObject execution = executions.get(i).getAsJsonObject();
                            long issueKey = execution.get("issueId").getAsLong();
                            long executionId = execution.get("id").getAsLong();
                            issueKeyExecutionIdMap.put(issueKey, executionId);
                            ++i;
                        }
                        break block15;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon receipt of execution ids <%s>", statusCode, url));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return issueKeyExecutionIdMap;
    }

    public static void processTestCaseDetails(ZephyrConfigModel zephyrData) {
        Long testCaseId = ZephyrTestCase.getTestCaseId(zephyrData);
        if (testCaseId == null) {
            ZephyrPlugin.log("Invalid Issue: " + zephyrData.getIssueName());
            return;
        }
        Long testid = ZephyrTestCase.fetchExecutionIds(zephyrData).get(testCaseId);
        ZephyrTestCase.executeTest(zephyrData, testid);
    }

    public static void executeTest(ZephyrConfigModel zephyrData, Long testId) {
        String url = String.format(URL_EXECUTE_TEST, zephyrData.getRestClient().getUrl(), testId);
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json")};
        TestCaseResultModel testCase = zephyrData.getTestcase();
        JsonObject obj = new JsonObject();
        obj.addProperty("status", (Number)(testCase.getIsPassed() != false ? 1 : 2));
        obj.addProperty("comment", testCase.getComment());
        StringEntity entity = null;
        try {
            entity = new StringEntity(obj.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Bad response entity upon execute test <%s>", url), e);
        }
        try {
            Throwable e = null;
            Object var8_11 = null;
            try (CloseableHttpResponse response = zephyrData.getRestClient().put(url, headers, (HttpEntity)entity);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 && statusCode >= 300) {
                    throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon execute test <%s>", statusCode, url));
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Map<String, Long> searchIssues(ZephyrConfigModel zephyrData) {
        long searchIssueStartcount = -1L;
        long totalIssueCount = 0L;
        long searchedIsssuesCount = 0L;
        HashMap<String, Long> searchedTests = new HashMap<String, Long>();
        do {
            String url = String.format(URL_GET_ALL_TESTS, zephyrData.getRestClient().getUrl(), zephyrData.getProjectId(), zephyrData.getTestIssueTypeId(), searchIssueStartcount, searchIssueStartcount);
            JsonArray searchedIssues = null;
            try {
                Throwable throwable = null;
                Object var11_10 = null;
                try (CloseableHttpResponse response = zephyrData.getRestClient().get(url);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(String.format("Bad response entity upon receipt of issues <%s>", url), e);
                        }
                        JsonObject testCaseIssues = new JsonParser().parse(string).getAsJsonObject();
                        totalIssueCount = testCaseIssues.get("total").getAsLong();
                        searchedIssues = testCaseIssues.get("issues").getAsJsonArray();
                        searchedIsssuesCount += (long)searchedIssues.size();
                    } else {
                        throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon receipt of issues <%s>", statusCode, url));
                    }
                    if (searchedIssues == null || searchedIssues.size() <= 0) continue;
                    int i = 0;
                    while (i < searchedIssues.size()) {
                        JsonObject jsonObject = searchedIssues.get(i).getAsJsonObject();
                        long testId = jsonObject.get("id").getAsLong();
                        String testKey = jsonObject.get("key").getAsString().trim();
                        searchedTests.put(testKey, testId);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } while (searchedIsssuesCount < totalIssueCount);
        return searchedTests;
    }
}

