/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2MiddleType;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public abstract class Element2MiddleProperty
implements Nameable {
    protected final @NonNull Relation2MiddleType relation2middleType;
    protected final @NonNull String nameHint;
    protected final @NonNull Class type;
    protected final boolean isRequired;
    private @Nullable Property traceProperty;

    protected Element2MiddleProperty(@NonNull Relation2MiddleType relation2middleType, @NonNull String name, @NonNull Class type, boolean isRequired) {
        this.relation2middleType = relation2middleType;
        this.nameHint = name;
        this.type = type;
        this.isRequired = isRequired;
    }

    protected abstract @NonNull Property createTraceProperty();

    protected @NonNull Property createMiddleProperty(@Nullable TypedModel rTypedModel, @NonNull String nameHint, boolean unitOpposite) {
        Type elementType;
        if (this.relation2middleType.getRelationalTransformation2TracePackage().isFrozen()) {
            throw new IllegalStateException("Creating " + nameHint + " after trace package frozen.");
        }
        Class traceClass = this.relation2middleType.getMiddleClass();
        String domainName = rTypedModel != null ? rTypedModel.getName() : null;
        String name = this.relation2middleType.getUniquePropertyName(this, nameHint);
        Property property = PivotFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setType((Type)this.type);
        property.setIsRequired(this.isRequired);
        if (this.type instanceof DataType && !((DataType)this.type).isIsSerializable()) {
            property.setIsTransient(true);
        }
        if (domainName != null) {
            Annotation domainAnnotation = PivotFactory.eINSTANCE.createAnnotation();
            domainAnnotation.setName("http://www.eclipse.org/qvt#Domains");
            Detail domainDetail = PivotFactory.eINSTANCE.createDetail();
            domainDetail.setName("referredDomain");
            domainDetail.getValues().add(domainName);
            domainAnnotation.getOwnedDetails().add(domainDetail);
            property.getOwnedAnnotations().add(domainAnnotation);
        }
        property.setOwningClass(traceClass);
        Class oppositeType = this.type;
        if (oppositeType instanceof CollectionType && (elementType = ((CollectionType)oppositeType).getElementType()) instanceof Class) {
            oppositeType = (Class)elementType;
        }
        if (!(oppositeType instanceof DataType)) {
            Property oppositeProperty = PivotFactory.eINSTANCE.createProperty();
            oppositeProperty.setName(traceClass.getName());
            oppositeProperty.setType((Type)(unitOpposite ? traceClass : this.relation2middleType.getBagOfMiddleClass()));
            oppositeProperty.setIsRequired(!unitOpposite);
            oppositeProperty.setIsImplicit(true);
            oppositeProperty.setOwningClass(oppositeType);
            property.setOpposite(oppositeProperty);
            oppositeProperty.setOpposite(property);
        }
        return property;
    }

    public @NonNull Property getTraceProperty() {
        Property traceProperty2 = this.traceProperty;
        if (traceProperty2 == null) {
            this.traceProperty = traceProperty2 = this.createTraceProperty();
        }
        return traceProperty2;
    }

    public @NonNull String getName() {
        return this.nameHint;
    }

    public @NonNull Property synthesize() {
        return this.getTraceProperty();
    }

    public String toString() {
        return String.valueOf(this.nameHint) + ":" + this.type + (this.isRequired ? "[1]" : "[?]");
    }
}

