/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private IWorkbenchSite fSite;
    private ISelectionProvider fSpecialSelectionProvider;

    protected SelectionDispatchAction(IWorkbenchSite site) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    public ISelection getSelection() {
        if (this.getSelectionProvider() != null) {
            return this.getSelectionProvider().getSelection();
        }
        return null;
    }

    public Shell getShell() {
        return this.fSite.getShell();
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.fSpecialSelectionProvider != null) {
            return this.fSpecialSelectionProvider;
        }
        return this.fSite.getSelectionProvider();
    }

    public void update(ISelection selection) {
        this.dispatchSelectionChanged(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(IStructuredSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ITextSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(ITextSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(false);
    }

    public void run(ISelection selection) {
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dispatchSelectionChanged(event.getSelection());
    }

    private void dispatchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.selectionChanged(selection);
        }
    }

    private void dispatchRun(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            this.run(selection);
        }
    }

    public void setSpecialSelectionProvider(ISelectionProvider provider) {
        this.fSpecialSelectionProvider = provider;
    }
}

