/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.resources.refactoring.Messages;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirtyEditorChange
extends Change {
    private final IFile oldFile;
    private final IFile newFile;

    public DirtyEditorChange(IFile oldFile, IFile newFile) {
        this.oldFile = oldFile;
        this.newFile = newFile;
    }

    public Object getModifiedElement() {
        return this.oldFile;
    }

    public String getName() {
        return Messages.DirtyEditorChange_0;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    private boolean hasDirtyEditors() {
        IMultiDiagramEditor[] list = EditorUtils.getRelatedEditors((IFile)this.oldFile);
        if (list != null && list.length > 0) {
            IMultiDiagramEditor[] iMultiDiagramEditorArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                IMultiDiagramEditor editor = iMultiDiagramEditorArray[n2];
                if (editor.isDirty()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        final RefactoringStatus status = new RefactoringStatus();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (DirtyEditorChange.this.hasDirtyEditors() && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.DirtyEditorChange_1, (String)Messages.DirtyEditorChange_2)) {
                    status.addFatalError(Messages.DirtyEditorChange_3);
                }
            }
        });
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        return new DirtyEditorChange(this.newFile, this.oldFile);
    }
}

