/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.DerivedTypedElementEvaluationException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.DerivedTypedElementTypeCheckingException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.query.DerivedTypedElementImplementationFactoryRegistry;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.query.QueryImplementationFactoryRegistry;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.query.QueryUtils;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IDerivedTypedElementImplementation;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.papyrus.emf.facet.util.core.Logger;

public class DerivedTypedElementManager
implements IDerivedTypedElementManager {
    @Override
    public Object evaluate(DerivedTypedElement derivedTypedElement, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        List result = derivedTypedElement.isMany() ? this.evaluateMultiValued(derivedTypedElement, source, parameterValues, null, facetManager) : this.evaluateSingleValued(derivedTypedElement, source, parameterValues, null, facetManager);
        return result;
    }

    @Override
    public Object evaluate(Query query, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        Object result;
        IQueryImplementation evaluator = QueryImplementationFactoryRegistry.INSTANCE.getEvaluatorFor(query, this);
        DerivedTypedElement derivedTE = QueryUtils.getOwningDerivedTypedElement(query);
        try {
            result = evaluator.getValue(query, derivedTE, source, parameterValues, facetManager);
        }
        catch (Exception e) {
            throw new DerivedTypedElementEvaluationException(e);
        }
        return result;
    }

    @Override
    public <T> T evaluateSingleValued(DerivedTypedElement derivedTypedElement, EObject source, List<ParameterValue> parameterValues, Class<T> expectedType, IFacetManager facetManager) throws DerivedTypedElementException {
        if (derivedTypedElement.isMany()) {
            throw new IllegalArgumentException("This method doesn't accept a multi-valued derived typed element.");
        }
        Query query = derivedTypedElement.getQuery();
        if (query == null) {
            throw new DerivedTypedElementException("The given derived typed element doesn't contain a query");
        }
        Object queryResult = this.evaluate(derivedTypedElement, source, parameterValues, facetManager, query);
        if (expectedType != null && queryResult != null && !expectedType.isInstance(queryResult)) {
            UnmatchingExpectedTypeException e1 = new UnmatchingExpectedTypeException("The derived typed element did not evaluate to the expected type", expectedType, queryResult);
            throw new DerivedTypedElementException(e1);
        }
        Object typedQueryResult = queryResult;
        return (T)typedQueryResult;
    }

    @Override
    public <T> List<T> evaluateMultiValued(DerivedTypedElement derivedTypedElement, EObject source, List<ParameterValue> parameterValues, Class<T> expectedType, IFacetManager facetManager) throws DerivedTypedElementException {
        List<Object> typedQueryListResult;
        List<Object> queryListResult;
        if (!derivedTypedElement.isMany()) {
            throw new IllegalArgumentException("This method doesn't accept a single-valued derived typed element.");
        }
        Query query = derivedTypedElement.getQuery();
        if (query == null) {
            throw new DerivedTypedElementException("The given derived typed element doesn't contain a query");
        }
        List<Object> queryResult = this.evaluate(derivedTypedElement, source, parameterValues, facetManager, query);
        if ((queryResult = DerivedTypedElementManager.setAsList(queryResult)) instanceof List) {
            queryListResult = queryResult;
            for (Object queryResultElement : queryListResult) {
                if (expectedType == null || queryResultElement == null || expectedType.isInstance(queryResultElement)) continue;
                UnmatchingExpectedTypeException e1 = new UnmatchingExpectedTypeException("The derived typed element did not evaluate to the expected type");
                throw new DerivedTypedElementException(e1);
            }
        } else {
            throw new DerivedTypedElementException("The given multi-valued derived typed element did not evaluate to a List.");
        }
        List<Object> result = typedQueryListResult = queryListResult;
        return result;
    }

    protected Object evaluate(DerivedTypedElement derivedTE, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager, Query query) throws DerivedTypedElementException {
        IQueryImplementation evaluator = null;
        IDerivedTypedElementImplementation evaluator2 = null;
        try {
            evaluator = QueryImplementationFactoryRegistry.INSTANCE.getEvaluatorFor(query, this);
        }
        catch (DerivedTypedElementException exc) {
            String message = String.format("%s will try to use a deprected implementation", this.getClass().getName());
            Logger.logError((Throwable)exc, (String)message, (Plugin)Activator.getDefault());
            evaluator2 = DerivedTypedElementImplementationFactoryRegistry.INSTANCE.getEvaluatorFor(query, this);
        }
        Object queryResult = evaluator == null ? DerivedTypedElementManager.evaluateAndCheck(derivedTE, source, parameterValues, evaluator2, facetManager) : DerivedTypedElementManager.evaluateAndCheck(derivedTE.getQuery(), source, parameterValues, evaluator, facetManager);
        return queryResult;
    }

    @Deprecated
    private static Object evaluateAndCheck(DerivedTypedElement derivedTE, EObject source, List<ParameterValue> parameterValues, IDerivedTypedElementImplementation evaluator, IFacetManager facetManager) throws DerivedTypedElementException {
        Object result;
        Query query = derivedTE.getQuery();
        DerivedTypedElementManager.checkQuery(query, source);
        try {
            result = evaluator.getValue(derivedTE, source, parameterValues, facetManager);
        }
        catch (Throwable e) {
            if (e instanceof DerivedTypedElementEvaluationException) {
                throw (DerivedTypedElementEvaluationException)e;
            }
            throw new DerivedTypedElementEvaluationException(e);
        }
        DerivedTypedElementManager.checkResult(query, result, evaluator.getCheckResultType(), DerivedTypedElementManager.isPrimitive(QueryUtils.getReturnType(query)));
        return result;
    }

    private static Object evaluateAndCheck(Query query, EObject source, List<ParameterValue> parameterValues, IQueryImplementation evaluator, IFacetManager facetManager) throws DerivedTypedElementException {
        Object result;
        DerivedTypedElementManager.checkQuery(query, source);
        try {
            result = evaluator.getValue(query, QueryUtils.getOwningDerivedTypedElement(query), source, parameterValues, facetManager);
        }
        catch (Throwable e) {
            if (e instanceof DerivedTypedElementEvaluationException) {
                throw (DerivedTypedElementEvaluationException)e;
            }
            throw new DerivedTypedElementEvaluationException(e);
        }
        DerivedTypedElementManager.checkResult(query, result, evaluator.isCheckResultType(), DerivedTypedElementManager.isPrimitive(QueryUtils.getReturnType(query)));
        return result;
    }

    private static void checkQuery(Query query, EObject source) throws DerivedTypedElementException {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        EClassifier sourceType = QueryUtils.getSourceType(query);
        if (sourceType == null && source != null) {
            throw new DerivedTypedElementException("the query's sourceType is null and the source is not null");
        }
        if (sourceType != null && source != null && !sourceType.isInstance((Object)source)) {
            StringBuffer message = new StringBuffer();
            message.append("Wrong source type (for " + QueryUtils.getQueryDescription(query) + "): '");
            message.append(source.eClass().getName());
            message.append("' found; expected '");
            message.append(sourceType.getName());
            message.append("'.");
            throw new DerivedTypedElementTypeCheckingException(message.toString());
        }
    }

    @Override
    public <T extends ETypedElementResult> List<T> batchEvaluate(DerivedTypedElement derivedTypedElement, Collection<? extends EObject> sources, List<ParameterValue> parameterValues, Class<T> expectedType, IFacetManager facetManager) throws DerivedTypedElementException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    private static final void checkResult(Query query, Object result, boolean checkResultType, boolean primitive) throws DerivedTypedElementTypeCheckingException {
        if (QueryUtils.isMany(query)) {
            if (!(result instanceof Collection)) {
                String strResult = result == null ? "null" : "an instance of " + result.getClass().getName();
                throw new DerivedTypedElementTypeCheckingException("A collection is expected as result. The result is " + strResult + " (on " + QueryUtils.getQueryDescription(query) + ")");
            }
            if (checkResultType) {
                for (Object collectionElement : (Collection)result) {
                    if (collectionElement == null || QueryUtils.getReturnType(query).isInstance(collectionElement)) continue;
                    throw new DerivedTypedElementTypeCheckingException("Wrong result collection element type: " + collectionElement.getClass().getName() + "(" + QueryUtils.getReturnType(query).getName() + " is expected) " + " on " + QueryUtils.getQueryDescription(query));
                }
            } else if (!primitive) {
                for (Object collectionElement : (Collection)result) {
                    if (collectionElement == null || collectionElement instanceof EObject) continue;
                    throw new DerivedTypedElementTypeCheckingException("Wrong result collection element type: " + collectionElement.getClass().getName() + "(an instance of " + EObject.class.getName() + " is expected) " + " on " + QueryUtils.getQueryDescription(query));
                }
            }
        } else {
            if (result instanceof Collection) {
                throw new DerivedTypedElementTypeCheckingException("A " + QueryUtils.getSourceType(query).getName() + " instance is expected as result. The result is: " + result + " (on " + QueryUtils.getQueryDescription(query) + ")");
            }
            if (checkResultType) {
                if (result != null && !QueryUtils.getReturnType(query).isInstance(result)) {
                    throw new DerivedTypedElementTypeCheckingException("Wrong result type: " + result.getClass().getName() + " is returned while " + QueryUtils.getReturnType(query).getInstanceClassName() + " is expected." + " (on " + QueryUtils.getQueryDescription(query) + ")");
                }
            } else if (!primitive && result != null && !(result instanceof EObject)) {
                throw new DerivedTypedElementTypeCheckingException("Wrong result collection element type: " + result.getClass().getName() + "(an instance of " + EObject.class.getName() + " is expected) " + " on " + QueryUtils.getQueryDescription(query));
            }
        }
    }

    private static boolean isPrimitive(EClassifier eType) {
        boolean primitiveType;
        if (eType instanceof EDataType) {
            primitiveType = true;
        } else if (eType instanceof EClass) {
            primitiveType = false;
        } else {
            throw new IllegalArgumentException("unhandled derived typed element type: " + eType.getName());
        }
        return primitiveType;
    }

    protected static List<Object> setAsList(Object element) {
        LinkedList<Object> newList = new LinkedList<Object>();
        if (element instanceof List) {
            List tmpList = (List)element;
            newList = tmpList;
        } else if (element instanceof Collection) {
            Collection result = (Collection)element;
            newList.addAll(result);
        } else {
            newList.add(element);
        }
        return newList;
    }
}

