/**
 * Copyright (c) 2009, 2019 Hatha Systems, and Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.modisco.omg.kdm.structure.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.modisco.omg.kdm.core.CoreFactory;
import org.eclipse.modisco.omg.kdm.core.provider.KDMEntityItemProvider;
import org.eclipse.modisco.omg.kdm.core.provider.KdmEditPlugin;
import org.eclipse.modisco.omg.kdm.structure.Component;
import org.eclipse.modisco.omg.kdm.structure.StructureFactory;
import org.eclipse.modisco.omg.kdm.structure.StructurePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.modisco.omg.kdm.structure.Component} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ComponentItemProvider extends KDMEntityItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addImplementationPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Implementation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addImplementationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_AbstractStructureElement_implementation_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_AbstractStructureElement_implementation_feature", "_UI_AbstractStructureElement_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__IMPLEMENTATION,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__AGGREGATED);
			childrenFeatures.add(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT);
			childrenFeatures.add(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_RELATIONSHIP);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns Component.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Component")); //$NON-NLS-1$
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((Component)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_Component_type") : //$NON-NLS-1$
			getString("_UI_Component_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}
	

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Component.class)) {
			case StructurePackage.COMPONENT__AGGREGATED:
			case StructurePackage.COMPONENT__STRUCTURE_ELEMENT:
			case StructurePackage.COMPONENT__STRUCTURE_RELATIONSHIP:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__AGGREGATED,
				 CoreFactory.eINSTANCE.createAggregatedRelationship()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createSubsystem()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createLayer()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createComponent()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createSoftwareSystem()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createArchitectureView()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_ELEMENT,
				 StructureFactory.eINSTANCE.createStructureElement()));

		newChildDescriptors.add
			(createChildParameter
				(StructurePackage.Literals.ABSTRACT_STRUCTURE_ELEMENT__STRUCTURE_RELATIONSHIP,
				 StructureFactory.eINSTANCE.createStructureRelationship()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return KdmEditPlugin.INSTANCE;
	}

}
