/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.IOException;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.describer.Version;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

abstract class AbstractParser {
    protected Version version;
    protected int idSize;
    protected final HprofPreferences.HprofStrictness strictnessPreference;
    private static final long MAX_UNSIGNED_4BYTE_INT = 0x100000000L;

    AbstractParser(HprofPreferences.HprofStrictness strictnessPreference) {
        this.strictnessPreference = strictnessPreference;
    }

    static Version readVersion(IPositionInputStream in) throws IOException {
        StringBuilder version = new StringBuilder();
        for (int bytesRead = 0; bytesRead < 20; ++bytesRead) {
            byte b = (byte)in.read();
            if (b != 0) {
                version.append((char)b);
                continue;
            }
            Version answer = Version.byLabel(version.toString());
            if (answer == null) {
                if (bytesRead <= 13) {
                    throw new IOException(Messages.AbstractParser_Error_NotHeapDump);
                }
                throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_UnknownHPROFVersion, (Object[])new Object[]{version.toString()}));
            }
            if (answer == Version.JDK12BETA3) {
                throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_UnsupportedHPROFVersion, (Object[])new Object[]{answer.getLabel()}));
            }
            return answer;
        }
        throw new IOException(Messages.AbstractParser_Error_InvalidHPROFHeader);
    }

    protected Object readValue(IPositionInputStream in, ISnapshot snapshot) throws IOException {
        byte type = in.readByte();
        return this.readValue(in, snapshot, type);
    }

    protected Object readValue(IPositionInputStream in, ISnapshot snapshot, int type) throws IOException {
        switch (type) {
            case 2: {
                long id = in.readID(this.idSize);
                return id == 0L ? null : new ObjectReference(snapshot, id);
            }
            case 4: {
                if (in.readByte() != 0) {
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.valueOf(in.readChar());
            }
            case 6: {
                return Float.valueOf(in.readFloat());
            }
            case 7: {
                return in.readDouble();
            }
            case 8: {
                return in.readByte();
            }
            case 9: {
                return in.readShort();
            }
            case 10: {
                return in.readInt();
            }
            case 11: {
                return in.readLong();
            }
        }
        throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_IllegalType, (Object[])new Object[]{type, in.position()}));
    }

    public static Object readValue(IPositionInputStream in, ISnapshot snapshot, int type, int idSize) throws IOException {
        switch (type) {
            case 2: {
                long id = in.readID(idSize);
                return id == 0L ? null : new ObjectReference(snapshot, id);
            }
            case 4: {
                if (in.readByte() != 0) {
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.valueOf(in.readChar());
            }
            case 6: {
                return Float.valueOf(in.readFloat());
            }
            case 7: {
                return in.readDouble();
            }
            case 8: {
                return in.readByte();
            }
            case 9: {
                return in.readShort();
            }
            case 10: {
                return in.readInt();
            }
            case 11: {
                return in.readLong();
            }
        }
        throw new IOException(MessageUtil.format((String)Messages.AbstractParser_Error_IllegalType, (Object[])new Object[]{type, in.position()}));
    }

    protected void skipValue(IPositionInputStream in) throws IOException {
        byte type = in.readByte();
        this.skipValue(in, type);
    }

    protected void skipValue(IPositionInputStream in, int type) throws IOException {
        if (type == 2) {
            in.skipBytes(this.idSize);
        } else {
            in.skipBytes(IPrimitiveArray.ELEMENT_SIZE[type]);
        }
    }

    protected String determineDumpNumber() {
        String dumpNr = System.getProperty("MAT_HPROF_DUMP_NR");
        return dumpNr;
    }

    protected String dumpIdentifier(int n) {
        return "#" + (n + 1);
    }

    protected boolean dumpMatches(int n, String match) {
        if (match == null && n == 0) {
            return true;
        }
        if (this.dumpIdentifier(n).equals(match)) {
            return true;
        }
        try {
            int nm = Integer.parseInt(match);
            return nm == n;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected long updateLengthIfNecessary(long fileSize, long curPos, int record, long length, SimpleMonitor.Listener monitor) {
        long bytesLeft;
        long length1;
        if (length == 0L && (this.strictnessPreference == HprofPreferences.HprofStrictness.STRICTNESS_WARNING || this.strictnessPreference == HprofPreferences.HprofStrictness.STRICTNESS_PERMISSIVE) && (length1 = fileSize - curPos - 9L) > 0L) {
            monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.AbstractParser_GuessedRecordLength, (Object[])new Object[]{Integer.toHexString(record), Long.toHexString(curPos), length, length1}), null);
            length = length1;
        }
        if (record == 12 && (bytesLeft = fileSize - curPos - 9L) >= 0x100000000L && (bytesLeft - length) % 0x100000000L == 0L) {
            monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_GuessingLengthOverflow, (Object[])new Object[]{Integer.toHexString(record), Long.toHexString(curPos), length, bytesLeft}), null);
            length = bytesLeft;
        }
        return length;
    }

    static interface Constants {

        public static interface DumpSegment {
            public static final int ROOT_UNKNOWN = 255;
            public static final int ROOT_JNI_GLOBAL = 1;
            public static final int ROOT_JNI_LOCAL = 2;
            public static final int ROOT_JAVA_FRAME = 3;
            public static final int ROOT_NATIVE_STACK = 4;
            public static final int ROOT_STICKY_CLASS = 5;
            public static final int ROOT_THREAD_BLOCK = 6;
            public static final int ROOT_MONITOR_USED = 7;
            public static final int ROOT_THREAD_OBJECT = 8;
            public static final int CLASS_DUMP = 32;
            public static final int INSTANCE_DUMP = 33;
            public static final int OBJECT_ARRAY_DUMP = 34;
            public static final int PRIMITIVE_ARRAY_DUMP = 35;
        }

        public static interface Record {
            public static final int STRING_IN_UTF8 = 1;
            public static final int LOAD_CLASS = 2;
            public static final int UNLOAD_CLASS = 3;
            public static final int STACK_FRAME = 4;
            public static final int STACK_TRACE = 5;
            public static final int ALLOC_SITES = 6;
            public static final int HEAP_SUMMARY = 7;
            public static final int START_THREAD = 10;
            public static final int END_THREAD = 11;
            public static final int HEAP_DUMP = 12;
            public static final int HEAP_DUMP_SEGMENT = 28;
            public static final int HEAP_DUMP_END = 44;
            public static final int CPU_SAMPLES = 13;
            public static final int CONTROL_SETTINGS = 14;
        }
    }
}

