/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index.nexus;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.Field;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.SearchType;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.fs.Lock;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ArtifactRepositoryRef;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.NoSuchComponentException;
import org.eclipse.m2e.core.internal.equinox.EquinoxLocker;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexListener;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.MatchTyped;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.internal.index.SourcedSearchExpression;
import org.eclipse.m2e.core.internal.index.nexus.AetherClientResourceFetcher;
import org.eclipse.m2e.core.internal.index.nexus.ArtifactScanningMonitor;
import org.eclipse.m2e.core.internal.index.nexus.CompositeIndex;
import org.eclipse.m2e.core.internal.index.nexus.IndexUpdaterJob;
import org.eclipse.m2e.core.internal.index.nexus.IndexedArtifactGroup;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.internal.repository.IRepositoryIndexer;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusIndexManager
implements IndexManager,
IMavenProjectChangedListener,
IRepositoryIndexer {
    private static final Logger log = LoggerFactory.getLogger(NexusIndexManager.class);
    public static final int MIN_CLASS_QUERY_LENGTH = 6;
    private NexusIndexer indexer;
    private ArtifactContextProducer artifactContextProducer;
    private final Object indexerLock = new Object();
    private final Object contextProducerLock = new Object();
    private final IMaven maven;
    private final IMavenProjectRegistry projectManager;
    private final IRepositoryRegistry repositoryRegistry;
    private final List<IndexCreator> fullCreators;
    private final List<IndexCreator> minCreators;
    private final File baseIndexDir;
    private final List<IndexListener> indexListeners = new ArrayList<IndexListener>();
    private NexusIndex localIndex;
    private final NexusIndex workspaceIndex;
    private final IndexUpdaterJob updaterJob;
    private final Properties indexDetails = new Properties();
    private final Set<String> updatingIndexes = new HashSet<String>();
    private final IndexUpdater indexUpdater;
    private static final EquinoxLocker locker = new EquinoxLocker();
    private final Map<String, Object> indexLocks = new WeakHashMap<String, Object>();
    private final PlexusContainer container;
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    public NexusIndexManager(PlexusContainer container, IMavenProjectRegistry projectManager, IRepositoryRegistry repositoryRegistry, File stateDir) {
        this.container = container;
        this.projectManager = projectManager;
        this.repositoryRegistry = repositoryRegistry;
        this.baseIndexDir = new File(stateDir, "nexus");
        this.maven = MavenPlugin.getMaven();
        try {
            this.indexUpdater = (IndexUpdater)container.lookup(IndexUpdater.class);
            this.fullCreators = Collections.unmodifiableList(this.getFullCreator());
            this.minCreators = Collections.unmodifiableList(this.getMinCreator());
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
        this.updaterJob = new IndexUpdaterJob(this);
        this.workspaceIndex = new NexusIndex(this, repositoryRegistry.getWorkspaceRepository(), "min");
    }

    private NexusIndex newLocalIndex(IRepository localRepository) {
        return new NexusIndex(this, localRepository, "full");
    }

    private List<IndexCreator> getFullCreator() throws ComponentLookupException {
        ArrayList<IndexCreator> creators = new ArrayList<IndexCreator>();
        IndexCreator min = (IndexCreator)this.container.lookup(IndexCreator.class, "min");
        IndexCreator mavenPlugin = (IndexCreator)this.container.lookup(IndexCreator.class, "maven-plugin");
        IndexCreator mavenArchetype = (IndexCreator)this.container.lookup(IndexCreator.class, "maven-archetype");
        IndexCreator jar = (IndexCreator)this.container.lookup(IndexCreator.class, "jarContent");
        creators.add(min);
        creators.add(jar);
        creators.add(mavenPlugin);
        creators.add(mavenArchetype);
        return creators;
    }

    private List<IndexCreator> getMinCreator() throws ComponentLookupException {
        ArrayList<IndexCreator> creators = new ArrayList<IndexCreator>();
        IndexCreator min = (IndexCreator)this.container.lookup(IndexCreator.class, "min");
        IndexCreator mavenArchetype = (IndexCreator)this.container.lookup(IndexCreator.class, "maven-archetype");
        creators.add(min);
        creators.add(mavenArchetype);
        return creators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedArtifactFile getIndexedArtifactFile(IRepository repository, ArtifactKey gav) throws CoreException {
        try {
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            query.add(this.constructQuery(MAVEN.GROUP_ID, gav.getGroupId(), SearchType.EXACT), BooleanClause.Occur.MUST);
            query.add(this.constructQuery(MAVEN.ARTIFACT_ID, gav.getArtifactId(), SearchType.EXACT), BooleanClause.Occur.MUST);
            query.add(this.constructQuery(MAVEN.VERSION, gav.getVersion(), SearchType.EXACT), BooleanClause.Occur.MUST);
            if (gav.getClassifier() != null) {
                query.add(this.constructQuery(MAVEN.CLASSIFIER, gav.getClassifier(), SearchType.EXACT), BooleanClause.Occur.MUST);
            }
            Object object = this.getIndexLock(repository);
            synchronized (object) {
                Collection artifactInfo = this.getIndexer().identify((Query)query.build(), Collections.singleton(this.getIndexingContext(repository)));
                if (artifactInfo != null && !artifactInfo.isEmpty()) {
                    return this.getIndexedArtifactFile((ArtifactInfo)artifactInfo.toArray()[0]);
                }
            }
        }
        catch (Exception ex) {
            String msg = "Illegal artifact coordinate " + ex.getMessage();
            log.error(msg, (Throwable)ex);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_search, (Throwable)ex));
        }
        return null;
    }

    public IndexedArtifactFile getIndexedArtifactFile(ArtifactInfo artifactInfo) {
        String groupId = artifactInfo.getGroupId();
        String artifactId = artifactInfo.getArtifactId();
        String repository = artifactInfo.getRepository();
        String version = artifactInfo.getVersion();
        String classifier = artifactInfo.getClassifier();
        String packaging = artifactInfo.getPackaging();
        String fname = artifactInfo.getFileName();
        if (fname == null) {
            fname = String.valueOf(artifactId) + '-' + version + (classifier != null ? String.valueOf('-') + classifier : "") + (packaging != null ? String.valueOf('.') + packaging : "");
        }
        long size = artifactInfo.getSize();
        Date date = new Date(artifactInfo.getLastModified());
        int sourcesExists = artifactInfo.getSourcesExists().ordinal();
        int javadocExists = artifactInfo.getJavadocExists().ordinal();
        String prefix = artifactInfo.getPrefix();
        List goals = artifactInfo.getGoals();
        return new IndexedArtifactFile(repository, groupId, artifactId, version, packaging, classifier, fname, size, date, sourcesExists, javadocExists, prefix, goals);
    }

    public IndexedArtifactFile identify(File file) throws CoreException {
        try {
            Collection artifactInfo = this.getIndexer().identify(file);
            return artifactInfo == null || artifactInfo.isEmpty() ? null : this.getIndexedArtifactFile((ArtifactInfo)artifactInfo.toArray()[0]);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_search, (Throwable)ex));
        }
    }

    protected IndexedArtifactFile identify(IRepository repository, File file) throws CoreException {
        IndexingContext context;
        block3: {
            try {
                context = this.getIndexingContext(repository);
                if (context != null) break block3;
                return null;
            }
            catch (IOException ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_search, (Throwable)ex));
            }
        }
        ArtifactInfo artifactInfo = this.identify(file, Collections.singleton(context));
        return artifactInfo == null ? null : this.getIndexedArtifactFile(artifactInfo);
    }

    public Query constructQuery(Field field, SearchExpression query) {
        MatchTyped.MatchType mt;
        SearchType st = SearchType.SCORED;
        if (query instanceof MatchTyped && MatchTyped.MatchType.EXACT.equals((Object)(mt = ((MatchTyped)((Object)query)).getMatchType()))) {
            st = SearchType.EXACT;
        }
        return this.constructQuery(field, query.getStringValue(), st);
    }

    private Query constructQuery(Field field, String query, SearchType searchType) {
        return this.getIndexer().constructQuery(field, query, searchType);
    }

    public Map<String, IndexedArtifact> search(SearchExpression term, String type) throws CoreException {
        return this.search(null, term, type, 15);
    }

    public Map<String, IndexedArtifact> search(SearchExpression term, String type, int classifier) throws CoreException {
        return this.search(null, term, type, classifier);
    }

    private void addClassifiersToQuery(BooleanQuery.Builder bq, int classifier) {
        boolean includeTests;
        boolean includeSources;
        boolean includeJavaDocs = (classifier & 2) > 0;
        Query tq = null;
        if (!includeJavaDocs) {
            tq = this.constructQuery(MAVEN.CLASSIFIER, "javadoc", SearchType.EXACT);
            bq.add(tq, BooleanClause.Occur.MUST_NOT);
        }
        boolean bl = includeSources = (classifier & 4) > 0;
        if (!includeSources) {
            tq = this.constructQuery(MAVEN.CLASSIFIER, "sources", SearchType.EXACT);
            bq.add(tq, BooleanClause.Occur.MUST_NOT);
        }
        boolean bl2 = includeTests = (classifier & 8) > 0;
        if (!includeTests) {
            tq = this.constructQuery(MAVEN.CLASSIFIER, "tests", SearchType.EXACT);
            bq.add(tq, BooleanClause.Occur.MUST_NOT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IndexedArtifact> search(IRepository repository, SearchExpression term, String type, int classifier) throws CoreException {
        BooleanQuery.Builder builder;
        Query tq;
        BooleanQuery.Builder bq;
        Query query;
        if ("groupId".equals(type)) {
            query = this.constructQuery(MAVEN.GROUP_ID, term);
        } else if ("artifact".equals(type)) {
            bq = new BooleanQuery.Builder();
            bq.add(this.constructQuery(MAVEN.GROUP_ID, term), BooleanClause.Occur.SHOULD);
            bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, term), BooleanClause.Occur.SHOULD);
            bq.add(this.constructQuery(MAVEN.SHA1, term.getStringValue(), term.getStringValue().length() == 40 ? SearchType.EXACT : SearchType.SCORED), BooleanClause.Occur.SHOULD);
            this.addClassifiersToQuery(bq, classifier);
            query = bq.build();
        } else if ("parents".equals(type)) {
            if (term == null) {
                query = this.constructQuery(MAVEN.PACKAGING, "pom", SearchType.EXACT);
            } else {
                bq = new BooleanQuery.Builder();
                bq.add(this.constructQuery(MAVEN.GROUP_ID, term), BooleanClause.Occur.SHOULD);
                bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, term), BooleanClause.Occur.SHOULD);
                bq.add(this.constructQuery(MAVEN.SHA1, term.getStringValue(), term.getStringValue().length() == 40 ? SearchType.EXACT : SearchType.SCORED), BooleanClause.Occur.SHOULD);
                tq = this.constructQuery(MAVEN.PACKAGING, "pom", SearchType.EXACT);
                builder = new BooleanQuery.Builder();
                builder.add((Query)bq.build(), BooleanClause.Occur.MUST);
                builder.add(tq, BooleanClause.Occur.FILTER);
                query = builder.build();
            }
        } else if ("plugin".equals(type)) {
            if (term == null) {
                query = this.constructQuery(MAVEN.PACKAGING, "maven-plugin", SearchType.EXACT);
            } else {
                bq = new BooleanQuery.Builder();
                bq.add(this.constructQuery(MAVEN.GROUP_ID, term), BooleanClause.Occur.SHOULD);
                bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, term), BooleanClause.Occur.SHOULD);
                tq = this.constructQuery(MAVEN.PACKAGING, "maven-plugin", SearchType.EXACT);
                builder = new BooleanQuery.Builder();
                builder.add((Query)bq.build(), BooleanClause.Occur.MUST);
                builder.add(tq, BooleanClause.Occur.FILTER);
                query = builder.build();
            }
        } else if ("archetype".equals(type)) {
            bq = new BooleanQuery.Builder();
            bq.add(this.constructQuery(MAVEN.GROUP_ID, term), BooleanClause.Occur.SHOULD);
            bq.add(this.constructQuery(MAVEN.ARTIFACT_ID, term), BooleanClause.Occur.SHOULD);
            tq = this.constructQuery(MAVEN.PACKAGING, "maven-archetype", SearchType.EXACT);
            builder = new BooleanQuery.Builder();
            builder.add((Query)bq.build(), BooleanClause.Occur.MUST);
            builder.add(tq, BooleanClause.Occur.FILTER);
            query = builder.build();
        } else if ("packaging".equals(type)) {
            query = this.constructQuery(MAVEN.PACKAGING, term);
        } else if ("sha1".equals(type)) {
            query = this.constructQuery(MAVEN.SHA1, term.getStringValue(), term.getStringValue().length() == 40 ? SearchType.EXACT : SearchType.SCORED);
        } else {
            return Collections.emptyMap();
        }
        TreeMap<String, IndexedArtifact> result = new TreeMap<String, IndexedArtifact>();
        try {
            Object object = this.getIndexLock(repository);
            synchronized (object) {
                IndexingContext context = this.getIndexingContext(repository);
                IteratorSearchResponse response = context == null ? this.getIndexer().searchIterator(new IteratorSearchRequest(query)) : this.getIndexer().searchIterator(new IteratorSearchRequest(query, context));
                for (ArtifactInfo artifactInfo : response.getResults()) {
                    this.addArtifactFile(result, this.getIndexedArtifactFile(artifactInfo), null, null, artifactInfo.getPackaging());
                }
                if ("groupId".equals(type) && context != null) {
                    Set groups = context.getAllGroups();
                    for (String group : groups) {
                        if (term != null && (!group.startsWith(term.getStringValue()) || group.equals(term.getStringValue()))) continue;
                        String key = this.getArtifactFileKey(group, group, null, null);
                        result.put(key, new IndexedArtifact(group, group, null, null, null));
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_search, (Throwable)ex));
        }
        return result;
    }

    protected Map<String, IndexedArtifact> search(IRepository repository, SearchExpression term, String type) throws CoreException {
        return this.search(repository, term, type, 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IndexedArtifact> search(IRepository repository, Query query) throws CoreException {
        TreeMap<String, IndexedArtifact> result = new TreeMap<String, IndexedArtifact>();
        try {
            IteratorSearchResponse response;
            Object object = this.getIndexLock(repository);
            synchronized (object) {
                IndexingContext context = this.getIndexingContext(repository);
                response = context == null ? this.getIndexer().searchIterator(new IteratorSearchRequest(query)) : this.getIndexer().searchIterator(new IteratorSearchRequest(query, context));
            }
            for (ArtifactInfo artifactInfo : response.getResults()) {
                this.addArtifactFile(result, this.getIndexedArtifactFile(artifactInfo), null, null, artifactInfo.getPackaging());
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_search, (Throwable)ex));
        }
        return result;
    }

    private void addArtifactFile(Map<String, IndexedArtifact> result, IndexedArtifactFile af, String className, String packageName, String packaging) {
        String group = af.group;
        String artifact = af.artifact;
        String key = this.getArtifactFileKey(group, artifact, packageName, className);
        IndexedArtifact indexedArtifact = result.get(key);
        if (indexedArtifact == null) {
            indexedArtifact = new IndexedArtifact(group, artifact, packageName, className, packaging);
            result.put(key, indexedArtifact);
        }
        indexedArtifact.addFile(af);
    }

    protected String getArtifactFileKey(String group, String artifact, String packageName, String className) {
        return String.valueOf(className) + " : " + packageName + " : " + group + " : " + artifact;
    }

    private void reindexLocalRepository(IRepository repository, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!force) {
            return;
        }
        try {
            try {
                this.fireIndexUpdating(repository);
                IndexingContext context = this.getIndexingContext(repository);
                if (context != null && (context = this.contextPurgeWorkaroundMINDEXER127(context)).getRepository().isDirectory()) {
                    this.getIndexer().scan(context, (ArtifactScanningListener)new ArtifactScanningMonitor(context.getRepository(), monitor), false);
                }
                log.info("Updated local repository index");
            }
            catch (Exception ex) {
                log.error("Unable to re-index " + repository.toString(), (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_reindexing, (Throwable)ex));
            }
        }
        finally {
            this.fireIndexChanged(repository);
        }
    }

    private IndexingContext contextPurgeWorkaroundMINDEXER127(IndexingContext context) throws IOException {
        this.getIndexer().removeIndexingContext(context, true);
        context = this.getIndexer().addIndexingContextForced(context.getId(), context.getRepositoryId(), context.getRepository(), context.getIndexDirectoryFile(), context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators());
        context.rebuildGroups();
        context.updateTimestamp(true, null);
        return context;
    }

    private void reindexWorkspace(boolean force) throws CoreException {
        IRepository workspaceRepository = this.repositoryRegistry.getWorkspaceRepository();
        if (!force) {
            return;
        }
        try {
            try {
                IndexingContext context = this.getIndexingContext(workspaceRepository);
                if (context != null) {
                    this.contextPurgeWorkaroundMINDEXER127(context);
                }
                IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
                int n = iMavenProjectFacadeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                    this.addDocument(workspaceRepository, facade.getPomFile(), facade.getArtifactKey());
                    ++n2;
                }
            }
            catch (Exception ex) {
                log.error("Unable to re-index " + workspaceRepository.toString(), (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_reindexing, (Throwable)ex));
            }
        }
        finally {
            this.fireIndexChanged(workspaceRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDocument(IRepository repository, File file, ArtifactKey key) {
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            IndexingContext context = this.getIndexingContext(repository);
            if (context == null) {
                return;
            }
            try {
                ArtifactContext artifactContext;
                if (repository.isScope(4)) {
                    IMavenProjectFacade facade = this.getProjectByArtifactKey(key);
                    artifactContext = this.getWorkspaceArtifactContext(facade);
                } else {
                    artifactContext = this.getArtifactContext(file, context);
                }
                this.getIndexer().addArtifactToIndex(artifactContext, context);
            }
            catch (Exception ex) {
                String msg = "Unable to add " + NexusIndexManager.getDocumentKey(key);
                log.error(msg, (Throwable)ex);
            }
        }
    }

    private IMavenProjectFacade getProjectByArtifactKey(ArtifactKey artifactKey) throws CoreException {
        IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
        int n = iMavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
            if (facade.getArtifactKey().equals(artifactKey)) {
                return facade;
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_unexpected, (Throwable)new IllegalArgumentException(String.format("Workspace project with key %s not found!", artifactKey))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(IRepository repository, File file, ArtifactKey key, IMavenProjectFacade facade) {
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            try {
                ArtifactContext artifactContext;
                IndexingContext context = this.getIndexingContext(repository);
                if (context == null) {
                    String msg = "Unable to find document to remove" + NexusIndexManager.getDocumentKey(key);
                    log.error(msg);
                    return;
                }
                if (repository.isScope(4)) {
                    if (facade == null) {
                        facade = this.getProjectByArtifactKey(key);
                    }
                    artifactContext = this.getWorkspaceArtifactContext(facade);
                } else {
                    artifactContext = this.getArtifactContext(file, context);
                }
                this.getIndexer().deleteArtifactFromIndex(artifactContext, context);
            }
            catch (Exception ex) {
                String msg = "Unable to remove " + NexusIndexManager.getDocumentKey(key);
                log.error(msg, (Throwable)ex);
            }
        }
        this.fireIndexChanged(repository);
    }

    private ArtifactContext getArtifactContext(File file, IndexingContext context) {
        return this.getArtifactContextProducer().getArtifactContext(context, file);
    }

    private ArtifactContext getWorkspaceArtifactContext(IMavenProjectFacade facade) {
        IRepository workspaceRepository = this.repositoryRegistry.getWorkspaceRepository();
        ArtifactKey key = facade.getArtifactKey();
        ArtifactInfo ai = new ArtifactInfo(workspaceRepository.getUid(), key.getGroupId(), key.getArtifactId(), key.getVersion(), key.getClassifier(), null);
        ai.setPackaging(facade.getPackaging());
        File pomFile = facade.getPomFile();
        File artifactFile = pomFile != null ? pomFile.getParentFile() : null;
        Gav gav = new Gav(key.getGroupId(), key.getArtifactId(), key.getVersion());
        return new ArtifactContext(pomFile, artifactFile, null, ai, gav);
    }

    protected void scheduleIndexUpdate(IRepository repository, boolean force) {
        if (repository != null) {
            IndexUpdaterJob.IndexCommand command = monitor -> this.updateIndex(repository, force, monitor);
            this.updaterJob.addCommand(command);
            this.updaterJob.schedule(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedArtifactGroup[] getRootIndexedArtifactGroups(IRepository repository) throws CoreException {
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            IndexingContext context = this.getIndexingContext(repository);
            if (context != null) {
                try {
                    Set rootGroups = context.getRootGroups();
                    IndexedArtifactGroup[] groups = new IndexedArtifactGroup[rootGroups.size()];
                    int i = 0;
                    for (String group : rootGroups) {
                        groups[i++] = new IndexedArtifactGroup(repository, group);
                    }
                    return groups;
                }
                catch (IOException ex) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.NexusIndexManager_error_root_grp, (Object)repository.toString()), (Throwable)ex));
                }
            }
            return new IndexedArtifactGroup[0];
        }
    }

    public IndexingContext getIndexingContext(IRepository repository) {
        return repository == null ? null : (IndexingContext)this.getIndexer().getIndexingContexts().get(repository.getUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NexusIndexer getIndexer() {
        Object object = this.indexerLock;
        synchronized (object) {
            if (this.indexer == null) {
                try {
                    this.indexer = (NexusIndexer)this.container.lookup(NexusIndexer.class);
                }
                catch (ComponentLookupException ex) {
                    throw new NoSuchComponentException(ex);
                }
            }
        }
        return this.indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactContextProducer getArtifactContextProducer() {
        Object object = this.contextProducerLock;
        synchronized (object) {
            if (this.artifactContextProducer == null) {
                try {
                    this.artifactContextProducer = (ArtifactContextProducer)this.container.lookup(ArtifactContextProducer.class);
                }
                catch (ComponentLookupException ex) {
                    throw new NoSuchComponentException(ex);
                }
            }
        }
        return this.artifactContextProducer;
    }

    public static String getDocumentKey(ArtifactKey artifact) {
        String groupId = artifact.getGroupId();
        if (groupId == null) {
            groupId = Messages.NexusIndexManager_inherited;
        }
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        if (version == null) {
            version = Messages.NexusIndexManager_inherited;
        }
        String key = String.valueOf(groupId.replace('.', '/')) + '/' + artifactId + '/' + version + '/' + artifactId + "-" + version;
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            key = String.valueOf(key) + "-" + classifier;
        }
        return String.valueOf(key) + ".pom";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        Object object = this.getIndexLock(this.repositoryRegistry.getWorkspaceRepository());
        synchronized (object) {
            IndexingContext context = this.getIndexingContext(this.repositoryRegistry.getWorkspaceRepository());
            if (context != null) {
                MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
                    IMavenProjectFacade oldFacade = event.getOldMavenProject();
                    IMavenProjectFacade facade = event.getMavenProject();
                    if (oldFacade != null) {
                        if (facade != null) {
                            this.addDocument(this.repositoryRegistry.getWorkspaceRepository(), facade.getPomFile(), facade.getArtifactKey());
                            this.fireIndexChanged(this.repositoryRegistry.getWorkspaceRepository());
                        } else {
                            this.removeDocument(this.repositoryRegistry.getWorkspaceRepository(), oldFacade.getPomFile(), oldFacade.getArtifactKey(), oldFacade);
                            this.fireIndexRemoved(this.repositoryRegistry.getWorkspaceRepository());
                        }
                    } else if (facade != null) {
                        this.addDocument(this.repositoryRegistry.getWorkspaceRepository(), facade.getPomFile(), facade.getArtifactKey());
                        this.fireIndexAdded(this.repositoryRegistry.getWorkspaceRepository());
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public NexusIndex getWorkspaceIndex() {
        return this.workspaceIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NexusIndex getLocalIndex() {
        IRepository localRepository = this.repositoryRegistry.getLocalRepository();
        Object object = this.getIndexLock(localRepository);
        synchronized (object) {
            if (this.localIndex == null) {
                this.localIndex = this.newLocalIndex(localRepository);
            }
        }
        return this.localIndex;
    }

    @Override
    public IIndex getIndex(IProject project) {
        IMavenProjectFacade projectFacade = project != null ? this.projectManager.getProject(project) : null;
        ArrayList<IIndex> indexes = new ArrayList<IIndex>();
        indexes.add(this.getWorkspaceIndex());
        indexes.add(this.getLocalIndex());
        if (projectFacade != null) {
            LinkedHashSet<ArtifactRepositoryRef> repositories = new LinkedHashSet<ArtifactRepositoryRef>();
            repositories.addAll(projectFacade.getArtifactRepositoryRefs());
            repositories.addAll(projectFacade.getPluginArtifactRepositoryRefs());
            for (ArtifactRepositoryRef repositoryRef : repositories) {
                IRepository repository = this.repositoryRegistry.getRepository(repositoryRef);
                if (repository == null) continue;
                indexes.add(this.getIndex(repository));
            }
        } else {
            for (IRepository repository : this.repositoryRegistry.getRepositories(8)) {
                indexes.add(this.getIndex(repository));
            }
        }
        return new CompositeIndex(indexes);
    }

    @Override
    public IIndex getAllIndexes() {
        ArrayList<IIndex> indexes = new ArrayList<IIndex>();
        indexes.add(this.getWorkspaceIndex());
        indexes.add(this.getLocalIndex());
        LinkedHashSet<ArtifactRepositoryRef> repositories = new LinkedHashSet<ArtifactRepositoryRef>();
        IMavenProjectFacade[] iMavenProjectFacadeArray = this.projectManager.getProjects();
        int n = iMavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
            repositories.addAll(facade.getArtifactRepositoryRefs());
            repositories.addAll(facade.getPluginArtifactRepositoryRefs());
            ++n2;
        }
        for (ArtifactRepositoryRef repositoryRef : repositories) {
            IRepository repository = this.repositoryRegistry.getRepository(repositoryRef);
            if (repository == null) continue;
            indexes.add(this.getIndex(repository));
        }
        return new CompositeIndex(indexes);
    }

    public NexusIndex getIndex(IRepository repository) {
        String details = this.getIndexDetails(repository);
        return new NexusIndex(this, repository, details);
    }

    protected File getIndexDirectoryFile(IRepository repository) {
        return new File(this.baseIndexDir, repository.getUid());
    }

    protected Directory getIndexDirectory(IRepository repository) throws IOException {
        return FSDirectory.open((Path)this.getIndexDirectoryFile(repository).toPath());
    }

    public IndexedArtifactGroup resolveGroup(IndexedArtifactGroup group) {
        IRepository repository = group.getRepository();
        String prefix = group.getPrefix();
        try {
            IndexedArtifactGroup g = new IndexedArtifactGroup(repository, prefix);
            for (IndexedArtifact a : this.search(repository, new SourcedSearchExpression(prefix), "groupId").values()) {
                String groupId = a.getGroupId();
                if (groupId.equals(prefix)) {
                    g.getFiles().put(a.getArtifactId(), a);
                    continue;
                }
                if (!groupId.startsWith(String.valueOf(prefix) + ".")) continue;
                int start = prefix.length() + 1;
                int end = groupId.indexOf(46, start);
                String key = end > -1 ? groupId.substring(0, end) : groupId;
                g.getNodes().put(key, new IndexedArtifactGroup(repository, key));
            }
            return g;
        }
        catch (CoreException ex) {
            log.error("Can't retrieve groups for " + repository.toString() + ":" + prefix, (Throwable)ex);
            return group;
        }
    }

    @Override
    public void repositoryAdded(IRepository repository, IProgressMonitor monitor) throws CoreException {
        String details = this.getIndexDetails(repository);
        this.setIndexDetails(repository, null, details, null);
    }

    public String getIndexDetails(IRepository repository) {
        String details = this.indexDetails.getProperty(repository.getUid());
        if (details == null) {
            details = repository.isScope(8) && repository.getMirrorId() == null ? "min" : (repository.isScope(2) ? "min" : (repository.isScope(4) ? "min" : "off"));
        }
        return details;
    }

    public void setIndexDetails(IRepository repository, String details, IProgressMonitor monitor) throws CoreException {
        this.setIndexDetails(repository, details, details, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIndexDetails(IRepository repository, String details, String defaultDetails, IProgressMonitor monitor) throws CoreException {
        if (details != null) {
            this.indexDetails.setProperty(repository.getUid(), details);
            this.writeIndexDetails();
        } else {
            details = defaultDetails;
        }
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            IndexingContext indexingContext = this.getIndexingContext(repository);
            try {
                if ("off".equals(details)) {
                    if (indexingContext != null) {
                        this.getIndexer().removeIndexingContext(indexingContext, false);
                        this.fireIndexRemoved(repository);
                    }
                } else {
                    if (indexingContext != null) {
                        this.getIndexer().removeIndexingContext(indexingContext, false);
                    }
                    this.createIndexingContext(repository);
                    this.fireIndexAdded(repository);
                    if (monitor != null) {
                        this.updateIndex(repository, false, monitor);
                    } else {
                        this.scheduleIndexUpdate(repository, false);
                    }
                }
            }
            catch (IOException ex) {
                String msg = "Error changing index details " + repository.toString();
                log.error(msg, (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_add_repo, (Throwable)ex));
            }
            if (repository.isScope(2)) {
                this.localIndex = this.newLocalIndex(this.repositoryRegistry.getLocalRepository());
            }
        }
    }

    protected IndexingContext createIndexingContext(IRepository repository) throws IOException {
        Directory directory = this.getIndexDirectory(repository);
        File repositoryPath = null;
        if (repository.getBasedir() != null) {
            repositoryPath = repository.getBasedir().getCanonicalFile();
        }
        IndexingContext indexingContext = this.getIndexer().addIndexingContextForced(repository.getUid(), repository.getUrl(), repositoryPath, directory, repository.getUrl(), null, this.minCreators);
        indexingContext.setSearchable(false);
        return indexingContext;
    }

    protected List<IndexCreator> getIndexers(String details) {
        boolean fullIndex = "full".equals(details);
        return fullIndex ? this.fullCreators : this.minCreators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryRemoved(IRepository repository, IProgressMonitor monitor) {
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            try {
                IndexingContext context = this.getIndexingContext(repository);
                if (context == null) {
                    return;
                }
                this.getIndexer().removeIndexingContext(context, false);
            }
            catch (IOException ie) {
                String msg = "Unable to delete files for index";
                log.error(msg, (Throwable)ie);
            }
        }
        this.fireIndexRemoved(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIndexAdded(IRepository repository) {
        List<IndexListener> list = this.indexListeners;
        synchronized (list) {
            for (IndexListener listener : this.indexListeners) {
                listener.indexAdded(repository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIndexRemoved(IRepository repository) {
        Collection<Object> collection = this.updatingIndexes;
        synchronized (collection) {
            if (repository != null) {
                this.updatingIndexes.remove(repository.getUid());
            }
        }
        collection = this.indexListeners;
        synchronized (collection) {
            for (IndexListener listener : this.indexListeners) {
                listener.indexRemoved(repository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpdatingIndex(IRepository repository) {
        Set<String> set = this.updatingIndexes;
        synchronized (set) {
            return this.updatingIndexes.contains(repository.getUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIndexUpdating(IRepository repository) {
        Collection<Object> collection = this.updatingIndexes;
        synchronized (collection) {
            if (repository != null) {
                this.updatingIndexes.add(repository.getUid());
            }
        }
        collection = this.indexListeners;
        synchronized (collection) {
            for (IndexListener listener : this.indexListeners) {
                listener.indexUpdating(repository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIndexChanged(IRepository repository) {
        if (repository == null) {
            return;
        }
        Collection<Object> collection = this.updatingIndexes;
        synchronized (collection) {
            this.updatingIndexes.remove(repository.getUid());
        }
        collection = this.indexListeners;
        synchronized (collection) {
            for (IndexListener listener : this.indexListeners) {
                listener.indexChanged(repository);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndexListener(IndexListener listener) {
        List<IndexListener> list = this.indexListeners;
        synchronized (list) {
            this.indexListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexListener(IndexListener listener) {
        List<IndexListener> list = this.indexListeners;
        synchronized (list) {
            if (!this.indexListeners.contains(listener)) {
                this.indexListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(IRepository repository, boolean force, IProgressMonitor monitor) throws CoreException {
        Object object = this.getIndexLock(repository);
        synchronized (object) {
            IndexingContext context;
            if (repository.isScope(4)) {
                this.reindexWorkspace(force);
            } else {
                context = this.getIndexingContext(repository);
                if (context != null) {
                    if (context.getRepository() != null) {
                        this.reindexLocalRepository(repository, force, monitor);
                    } else if (!force) {
                        IMavenConfiguration mavenConfig = MavenPlugin.getMavenConfiguration();
                        if (mavenConfig.isUpdateIndexesOnStartup()) {
                            this.updateRemoteIndex(repository, force, monitor);
                        }
                    } else {
                        this.updateRemoteIndex(repository, force, monitor);
                    }
                }
            }
            context = this.getIndexingContext(repository);
            if (context != null) {
                context.setSearchable(true);
            }
        }
    }

    private void updateRemoteIndex(IRepository repository, boolean force, IProgressMonitor monitor) {
        block16: {
            if (repository == null) {
                return;
            }
            long start = System.currentTimeMillis();
            if (monitor != null) {
                monitor.setTaskName(NLS.bind((String)Messages.NexusIndexManager_task_updating, (Object)repository.toString()));
            }
            log.info("Updating index for repository: {}", (Object)repository.toString());
            try {
                try {
                    this.fireIndexUpdating(repository);
                    IndexingContext context = this.getIndexingContext(repository);
                    if (context == null) break block16;
                    IndexUpdateRequest request = this.newIndexUpdateRequest(repository, context, monitor);
                    request.setForceFullUpdate(force);
                    Lock cacheLock = locker.lock(request.getLocalIndexCacheDir());
                    try {
                        boolean updated;
                        request.setCacheOnly(true);
                        IndexUpdateResult result = this.indexUpdater.fetchAndUpdateIndex(request);
                        if (result.isFullUpdate() || !context.isSearchable()) {
                            String details = this.getIndexDetails(repository);
                            String id = String.valueOf(repository.getUid()) + "-cache";
                            File luceneCache = new File(request.getLocalIndexCacheDir(), details);
                            FSDirectory directory = FSDirectory.open((Path)luceneCache.toPath());
                            IndexingContext cacheCtx = this.getIndexer().addIndexingContextForced(id, id, null, (Directory)directory, null, null, this.getIndexers(details));
                            request = this.newIndexUpdateRequest(repository, cacheCtx, monitor);
                            request.setOffline(true);
                            this.indexUpdater.fetchAndUpdateIndex(request);
                            this.getIndexer().removeIndexingContext(context, true);
                            this.getIndexer().removeIndexingContext(cacheCtx, false);
                            FileUtils.cleanDirectory((File)context.getIndexDirectoryFile());
                            FileUtils.copyDirectory((File)luceneCache, (File)context.getIndexDirectoryFile());
                            context = this.createIndexingContext(repository);
                            updated = true;
                        } else {
                            request = this.newIndexUpdateRequest(repository, context, monitor);
                            request.setOffline(true);
                            result = this.indexUpdater.fetchAndUpdateIndex(request);
                            boolean bl = updated = result.getTimestamp() != null;
                        }
                        if (updated) {
                            log.info("Updated index for repository: {} in {} ms", (Object)repository.toString(), (Object)(System.currentTimeMillis() - start));
                        } else {
                            log.info("No index update available for repository: {}", (Object)repository.toString());
                        }
                    }
                    finally {
                        cacheLock.release();
                    }
                }
                catch (FileNotFoundException e) {
                    String msg = "Unable to update index for " + repository.toString() + ": " + e.getMessage();
                    log.error(msg, (Throwable)e);
                    this.fireIndexChanged(repository);
                }
                catch (Exception ie) {
                    String msg = "Unable to update index for " + repository.toString();
                    log.error(msg, (Throwable)ie);
                    this.fireIndexChanged(repository);
                }
            }
            finally {
                this.fireIndexChanged(repository);
            }
        }
    }

    protected IndexUpdateRequest newIndexUpdateRequest(IRepository repository, IndexingContext context, IProgressMonitor monitor) throws IOException, CoreException {
        ProxyInfo proxyInfo = this.maven.getProxyInfo(repository.getProtocol());
        AuthenticationInfo authenticationInfo = repository.getAuthenticationInfo();
        IndexUpdateRequest request = new IndexUpdateRequest(context, (ResourceFetcher)new AetherClientResourceFetcher(authenticationInfo, proxyInfo, monitor));
        File localRepo = this.repositoryRegistry.getLocalRepository().getBasedir();
        File indexCacheBasedir = new File(localRepo, ".cache/m2e/" + MavenPluginActivator.getVersion()).getCanonicalFile();
        File indexCacheDir = new File(indexCacheBasedir, repository.getUid());
        indexCacheDir.mkdirs();
        request.setLocalIndexCacheDir(indexCacheDir);
        return request;
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.getIndexDetailsFile()));){
                this.indexDetails.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_read_index, (Throwable)e));
        }
    }

    protected void writeIndexDetails() throws CoreException {
        try {
            File indexDetailsFile = this.getIndexDetailsFile();
            indexDetailsFile.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(indexDetailsFile));){
                this.indexDetails.store(os, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.NexusIndexManager_error_write_index, (Throwable)e));
        }
    }

    private File getIndexDetailsFile() {
        return new File(this.baseIndexDir, "indexDetails.properties");
    }

    public Job getIndexUpdateJob() {
        return this.updaterJob;
    }

    @Override
    public String getIndexerId() {
        return Messages.NexusIndexManager_78;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIndexLock(IRepository repository) {
        if (repository == null) {
            return new Object();
        }
        Map<String, Object> map = this.indexLocks;
        synchronized (map) {
            Object lock = this.indexLocks.get(repository.getUid());
            if (lock == null) {
                lock = new Object();
                this.indexLocks.put(repository.getUid(), lock);
            }
            return lock;
        }
    }

    protected ArtifactInfo identify(File artifact, Collection<IndexingContext> contexts) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(artifact);){
                int n;
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] buff = new byte[4096];
                while ((n = is.read(buff)) > -1) {
                    sha1.update(buff, 0, n);
                }
                byte[] digest = sha1.digest();
                Query q = this.getIndexer().constructQuery(MAVEN.SHA1, NexusIndexManager.encode(digest), SearchType.EXACT);
                Collection result = this.getIndexer().identify(q, contexts);
                ArtifactInfo artifactInfo = result == null || result.isEmpty() ? null : (ArtifactInfo)result.toArray()[0];
                return artifactInfo;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Unable to calculate digest");
        }
    }

    private static String encode(byte[] digest) {
        char[] buff = new char[digest.length * 2];
        int n = 0;
        byte[] byArray = digest;
        int n2 = digest.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b = byArray[n3];
            buff[n++] = DIGITS[(0xF0 & b) >> 4];
            buff[n++] = DIGITS[0xF & b];
            ++n3;
        }
        return new String(buff);
    }

    public IndexUpdater getIndexUpdate() {
        return this.indexUpdater;
    }

    public ArchetypeDataSource getArchetypeCatalog() {
        try {
            return (ArchetypeDataSource)this.container.lookup(ArchetypeDataSource.class, "nexus");
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
    }
}

