/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

final class BinaryEnum
extends BinaryAbstractType
implements JavaResourceEnum {
    private final Vector<JavaResourceEnumConstant> enumConstants = new Vector();
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final Predicate<IField> FIELD_IS_ENUM_CONSTANT = new FieldIsEnumConstant();

    BinaryEnum(JavaResourceModel parent, IType type) {
        this(parent, new BinaryAbstractType.TypeAdapter(type));
    }

    private BinaryEnum(JavaResourceModel parent, BinaryAbstractType.TypeAdapter adapter) {
        super(parent, adapter);
        CollectionTools.addAll(this.enumConstants, this.buildEnumConstants());
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.ENUM;
    }

    @Override
    public void synchronizeWith(EnumDeclaration enumDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(EnumDeclaration enumDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update() {
        super.update();
        this.updateEnumConstants();
    }

    private void updateEnumConstants() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceEnumConstant> getEnumConstants() {
        return IterableTools.cloneLive(this.enumConstants);
    }

    private Iterable<JavaResourceEnumConstant> buildEnumConstants() {
        return IterableTools.transform(this.getEnumConstants(this.getElement()), (Transformer)new FieldEnumConstantTransformer());
    }

    private Iterable<IField> getEnumConstants(IType type) {
        return IterableTools.filter((Iterable)IterableTools.iterable((Object[])this.getFields(type)), FIELD_IS_ENUM_CONSTANT);
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    JavaResourceEnumConstant buildEnumConstant(IField jdtEnumConstant) {
        return new BinaryEnumConstant((JavaResourceEnum)this, jdtEnumConstant);
    }

    class FieldEnumConstantTransformer
    extends TransformerAdapter<IField, JavaResourceEnumConstant> {
        FieldEnumConstantTransformer() {
        }

        public JavaResourceEnumConstant transform(IField field) {
            return BinaryEnum.this.buildEnumConstant(field);
        }
    }

    static class FieldIsEnumConstant
    extends PredicateAdapter<IField> {
        FieldIsEnumConstant() {
        }

        public boolean evaluate(IField field) {
            try {
                return this.evaluate_(field);
            }
            catch (JavaModelException ex) {
                JptCommonCorePlugin.instance().logError(ex);
                return false;
            }
        }

        private boolean evaluate_(IField field) throws JavaModelException {
            return field.isEnumConstant();
        }
    }
}

