/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.ui.internal.admin.StoreType;
import org.eclipse.emf.cdo.ui.internal.admin.messages.Messages;
import org.eclipse.emf.cdo.ui.internal.admin.wizards.AbstractCreateRepositoryWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CreateRepositoryGeneralPage
extends AbstractCreateRepositoryWizardPage {
    public static final String PROPERTY_NAME = "name";
    private final Map<String, StoreType> storeTypes;
    private Text nameText;
    private Button enableAuditingCheckbox;
    private Button enableBranchingCheckbox;
    private Button referentialIntegrityCheckbox;
    private Button allowInterruptQueriesCheckbox;
    private Text overrideUUIDText;
    private ComboViewer idGenerationLocationCombo;
    private Button securityCheckbox;
    private Button homeFoldersCheckbox;
    private ComboViewer storeCombo;
    private StoreType storeType;

    public CreateRepositoryGeneralPage(String pageName, List<StoreType> storeTypes) {
        super(pageName);
        this.setTitle(Messages.CreateRepositoryGeneralPage_5);
        this.setMessage(Messages.CreateRepositoryGeneralPage_0);
        this.storeTypes = CreateRepositoryGeneralPage.mapStoreTypes(storeTypes);
    }

    @Override
    protected void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout());
        Group properties = this.group(composite, Messages.CreateRepositoryGeneralPage_6);
        this.nameText = this.text((Composite)properties, Messages.CreateRepositoryGeneralPage_1);
        this.enableAuditingCheckbox = this.checkbox((Composite)properties, Messages.CreateRepositoryGeneralPage_7);
        this.enableBranchingCheckbox = this.checkbox((Composite)properties, Messages.CreateRepositoryGeneralPage_8);
        this.referentialIntegrityCheckbox = this.checkbox((Composite)properties, Messages.CreateRepositoryGeneralPage_10);
        this.allowInterruptQueriesCheckbox = this.checkbox((Composite)properties, Messages.CreateRepositoryGeneralPage_11);
        this.overrideUUIDText = this.text((Composite)properties, Messages.CreateRepositoryGeneralPage_12);
        this.idGenerationLocationCombo = this.combo((Composite)properties, Messages.CreateRepositoryGeneralPage_13, CDOCommonRepository.IDGenerationLocation.values());
        Group security = this.group(composite, Messages.CreateRepositoryGeneralPage_14);
        this.securityCheckbox = this.checkbox((Composite)security, Messages.CreateRepositoryGeneralPage_2);
        this.homeFoldersCheckbox = this.checkbox((Composite)security, Messages.CreateRepositoryGeneralPage_3);
        Group store = this.group(composite, Messages.CreateRepositoryGeneralPage_15);
        this.storeCombo = this.combo((Composite)store, Messages.CreateRepositoryGeneralPage_4, this.storeTypes.values());
    }

    @Override
    protected void hookListeners(Listener updateListener) {
        this.enableAuditingCheckbox.addListener(13, updateListener);
        this.securityCheckbox.addListener(13, updateListener);
        this.nameText.addListener(24, updateListener);
        this.storeCombo.getCombo().addListener(13, updateListener);
    }

    @Override
    protected void updateEnablement(boolean firstTime) {
        this.homeFoldersCheckbox.setEnabled(this.securityCheckbox.getSelection());
        this.enableBranchingCheckbox.setEnabled(this.enableAuditingCheckbox.getSelection());
        StoreType newStoreType = (StoreType)UIUtil.getElement((ISelection)this.storeCombo.getSelection(), StoreType.class);
        if (this.storeType != newStoreType) {
            this.storeType = newStoreType;
            this.publish(this.storeType);
        }
        boolean nameOK = !StringUtil.isEmpty((String)this.nameText.getText().trim());
        boolean storeTypeOK = this.storeType != null;
        this.setPageComplete(nameOK && storeTypeOK);
    }

    protected CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return (CDOCommonRepository.IDGenerationLocation)UIUtil.getElement((ISelection)this.idGenerationLocationCombo.getSelection(), CDOCommonRepository.IDGenerationLocation.class);
    }

    @Override
    protected boolean collectRepositoryProperties(Map<String, Object> repositoryProperties) {
        repositoryProperties.put(PROPERTY_NAME, this.nameText.getText().trim());
        repositoryProperties.put("supportingAudits", this.checked(this.enableAuditingCheckbox));
        repositoryProperties.put("supportingBranches", this.checked(this.enableBranchingCheckbox));
        repositoryProperties.put("ensureReferentialIntegrity", this.checked(this.referentialIntegrityCheckbox));
        repositoryProperties.put("allowInterruptRunningQueries", this.checked(this.allowInterruptQueriesCheckbox));
        repositoryProperties.put("overrideUUID", this.text(this.overrideUUIDText));
        repositoryProperties.put("idGenerationLocation", this.getIDGenerationLocation().name());
        repositoryProperties.put("configureSecurityManager", this.checked(this.securityCheckbox));
        repositoryProperties.put("configureSecurityHomeFolders", this.checked(this.homeFoldersCheckbox));
        return true;
    }

    @Override
    protected void loadSettings(IDialogSettings pageSettings) {
        this.enableAuditingCheckbox.setSelection(this.getSetting(pageSettings, "enableAuditing", true));
        this.enableBranchingCheckbox.setSelection(this.getSetting(pageSettings, "enableBranching", true));
        this.referentialIntegrityCheckbox.setSelection(this.getSetting(pageSettings, "referentialIntegrity", false));
        this.allowInterruptQueriesCheckbox.setSelection(this.getSetting(pageSettings, "allowInterruptQueries", true));
        CDOCommonRepository.IDGenerationLocation idGen = CDOCommonRepository.IDGenerationLocation.valueOf((String)this.getSetting(pageSettings, "idGeneration", CDOCommonRepository.IDGenerationLocation.STORE.name()));
        this.idGenerationLocationCombo.setSelection((ISelection)new StructuredSelection((Object)idGen));
        this.securityCheckbox.setSelection(this.getSetting(pageSettings, "security", true));
        this.homeFoldersCheckbox.setSelection(this.getSetting(pageSettings, "homeFolders", true));
        StoreType storeType = this.storeTypes.get(this.getSetting(pageSettings, "storeType", null));
        if (storeType != null) {
            this.storeCombo.setSelection((ISelection)new StructuredSelection((Object)storeType));
        } else {
            this.storeCombo.getCombo().select(0);
        }
    }

    @Override
    protected void saveSettings(IDialogSettings pageSettings) {
        pageSettings.put("enableAuditing", this.enableAuditingCheckbox.getSelection());
        pageSettings.put("enableBranching", this.enableBranchingCheckbox.getSelection());
        pageSettings.put("referentialIntegrity", this.referentialIntegrityCheckbox.getSelection());
        pageSettings.put("allowInterruptQueries", this.allowInterruptQueriesCheckbox.getSelection());
        pageSettings.put("idGeneration", this.getIDGenerationLocation().name());
        pageSettings.put("security", this.securityCheckbox.getSelection());
        pageSettings.put("homeFolders", this.homeFoldersCheckbox.getSelection());
        pageSettings.put("storeType", this.storeType.getID());
    }

    private static Map<String, StoreType> mapStoreTypes(List<StoreType> storeTypes) {
        HashMap<String, StoreType> result = new HashMap<String, StoreType>();
        for (StoreType storeType : storeTypes) {
            result.put(storeType.getID(), storeType);
        }
        return result;
    }
}

