/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.embedded;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.embedded.EmbeddedRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class CDOEmbeddedRepositoryConfig
extends Lifecycle
implements IManagedContainerProvider {
    private static final String JVM_ACCEPTOR_PREFIX = "cdo_embedded_repo_";
    private final String repositoryName;
    private EmbeddedRepository repository;

    public CDOEmbeddedRepositoryConfig(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final IRepository getRepository() {
        return this.repository;
    }

    public final CDONet4jSession openClientSession() {
        return this.repository.openClientSession();
    }

    public IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    public void initPackages(IRepository repository, List<EPackage> packages) {
        for (String nsURI : new HashSet(EPackage.Registry.INSTANCE.keySet())) {
            if (!this.isInitialPackage(repository, nsURI)) continue;
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            packages.add(ePackage);
        }
    }

    public boolean isInitialPackage(IRepository repository, String nsURI) {
        return false;
    }

    public void afterFirstStart(IRepository repository) {
    }

    public void afterReStart(IRepository repository) {
    }

    public void modifySession(IRepository repository, CDONet4jSession session) {
        session.options().setCommitTimeout(Integer.MAX_VALUE);
    }

    public CDONet4jSessionConfiguration createSessionConfiguration(IConnector connector, CDOBranchManager branchManager, CDORevisionManager revisionManager) {
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(this.repositoryName);
        configuration.setSignalTimeout(Integer.MAX_VALUE);
        configuration.setBranchManager(branchManager);
        configuration.setRevisionManager(revisionManager);
        return configuration;
    }

    public IAcceptor createAcceptor(IManagedContainer container) {
        return JVMUtil.getAcceptor((IManagedContainer)container, (String)(JVM_ACCEPTOR_PREFIX + this.repositoryName));
    }

    public IConnector createConnector(IManagedContainer container) {
        return JVMUtil.getConnector((IManagedContainer)container, (String)(JVM_ACCEPTOR_PREFIX + this.repositoryName));
    }

    public abstract IStore createStore(IManagedContainer var1);

    public abstract void initProperties(IManagedContainer var1, Map<String, String> var2);

    protected void activateRepository(IRepository repository) {
        LifecycleUtil.activate((Object)repository);
    }

    protected void deactivateRepository() {
        LifecycleUtil.deactivate((Object)((Object)this.repository));
        this.repository = null;
    }

    protected void doActivate() throws Exception {
        IManagedContainer container = this.getContainer();
        IStore store = this.createStore(container);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("overrideUUID", "");
        this.initProperties(container, properties);
        this.repository = new EmbeddedRepository(this);
        this.repository.setContainer(container);
        this.repository.setName(this.repositoryName);
        this.repository.setStore((InternalStore)store);
        this.repository.setProperties(properties);
        this.activateRepository((IRepository)this.repository);
        this.repository.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                CDOEmbeddedRepositoryConfig.this.deactivate();
            }
        });
    }

    protected void doDeactivate() throws Exception {
        this.deactivateRepository();
    }
}

