/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;

public class LandmarkMarkerManager
extends AbstractContextListener {
    private static final String ID_MARKER_LANDMARK = "org.eclipse.mylyn.context.ui.markers.landmark";
    private final Map<IInteractionElement, Long> markerMap = new HashMap<IInteractionElement, Long>();

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: 
            case DEACTIVATED: {
                this.modelUpdated();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext()) break;
                this.modelUpdated();
                break;
            }
            case LANDMARKS_ADDED: {
                for (IInteractionElement element : event.getElements()) {
                    this.addLandmarkMarker(element);
                }
                break;
            }
            case LANDMARKS_REMOVED: {
                for (IInteractionElement element : event.getElements()) {
                    this.removeLandmarkMarker(element);
                }
                break;
            }
        }
    }

    private void modelUpdated() {
        try {
            for (IInteractionElement node : this.markerMap.keySet()) {
                this.removeLandmarkMarker(node);
            }
            this.markerMap.clear();
            for (IInteractionElement node : ContextCore.getContextManager().getActiveLandmarks()) {
                this.addLandmarkMarker(node);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update landmark markers", t));
        }
    }

    public void addLandmarkMarker(IInteractionElement node) {
        if (node == null || node.getContentType() == null) {
            return;
        }
        if (node.getContentType().equals("DLTK")) {
            IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element instanceof IMember) {
                try {
                    ISourceRange range = ((IMember)element).getNameRange();
                    IResource resource = element.getUnderlyingResource();
                    if (resource instanceof IFile) {
                        IWorkspaceRunnable runnable = monitor -> {
                            IMarker marker = resource.createMarker(ID_MARKER_LANDMARK);
                            if (marker != null && range != null) {
                                marker.setAttribute("charStart", range.getOffset());
                                marker.setAttribute("charEnd", range.getOffset() + range.getLength());
                                marker.setAttribute("message", (Object)"Mylyn Landmark");
                                marker.setAttribute("severity", 0);
                                this.markerMap.put(node, marker.getId());
                            }
                        };
                        resource.getWorkspace().run(runnable, null);
                    }
                }
                catch (ModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update marker", (Throwable)e));
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update marker", (Throwable)e));
                }
            }
        }
    }

    public void removeLandmarkMarker(IInteractionElement node) {
        if (node == null) {
            return;
        }
        if (node.getContentType().equals("DLTK")) {
            IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
            if (!element.exists()) {
                return;
            }
            if (element.getAncestor(1) != null && element instanceof ISourceReference) {
                try {
                    IResource resource = element.getUnderlyingResource();
                    IWorkspaceRunnable runnable = monitor -> {
                        if (resource != null) {
                            try {
                                long id;
                                IMarker marker;
                                if (this.markerMap.containsKey(node) && (marker = resource.getMarker(id = this.markerMap.get(node).longValue())) != null) {
                                    marker.delete();
                                }
                            }
                            catch (NullPointerException e) {
                                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update marker", (Throwable)e));
                            }
                        }
                    };
                    resource.getWorkspace().run(runnable, null);
                }
                catch (ModelException resource) {
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update landmark marker", (Throwable)e));
                }
            }
        }
    }
}

