/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.debug.gdbjtag.ui.Messages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GDBJtagDSFDebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = Messages.getString("GDBJtagDebuggerTab.tabName");
    private static final String TAB_ID = "org.eclipse.cdt.debug.gdbjtag.ui.debuggertab.dsf";
    private static final String DEFAULT_JTAG_DEVICE_ID = "org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.genericDevice";
    private static final String ATTR_JTAG_DEVICE = "org.eclipse.cdt.debug.gdbjtag.core.jtagDevice";
    private Text gdbCommand;
    private Button useRemote;
    private Combo jtagDevice;
    private Composite remoteConnectionParameters;
    private StackLayout remoteConnectParmsLayout;
    private Composite remoteConnectionBox;
    private Text connection;
    private String savedJtagDevice;
    protected Button fUpdateThreadlistOnSuspend;
    private Button remoteTimeoutEnabled;
    private Text remoteTimeoutValue;

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.gdbSetupGroup_Text"));
        this.createCommandControl((Composite)group);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("GDBJtagDebuggerTab.update_thread_list_on_suspend"));
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUpdateThreadlistOnSuspend.setLayoutData((Object)gd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpdateThreadlistOnSuspend, "org.eclipse.cdt.dsf.gdb.ui.update_threadlist_button_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.launch_configuration_dialog_debugger_tab");
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createCommandControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandLabel"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.gdbCommand = new Text(comp, 2052);
        gd = new GridData(768);
        this.gdbCommand.setLayoutData((Object)gd);
        this.gdbCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.browseButtonSelected(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse_Title"), GDBJtagDSFDebuggerTab.this.gdbCommand);
            }
        });
        button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandVariable"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.variablesButtonSelected(GDBJtagDSFDebuggerTab.this.gdbCommand);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.remoteGroup_Text"));
        this.useRemote = new Button((Composite)group, 32);
        this.useRemote.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.useRemote.setText(Messages.getString("GDBJtagDebuggerTab.useRemote_Text"));
        this.useRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.useRemoteChanged();
                GDBJtagDSFDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.remoteTimeoutEnabled = new Button((Composite)group, 32);
        this.remoteTimeoutEnabled.setText(Messages.getString("GDBJtagDebuggerTab.remoteTimeout"));
        this.remoteTimeoutEnabled.setToolTipText(Messages.getString("GDBJtagDebuggerTab.remoteTimeoutTooltip"));
        this.remoteTimeoutEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDSFDebuggerTab.this.remoteTimeoutChanged();
                GDBJtagDSFDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.remoteTimeoutValue = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.widthHint = new PixelConverter((Control)this.remoteTimeoutValue).convertWidthInCharsToPixels(10);
        this.remoteTimeoutValue.setLayoutData((Object)gd);
        this.remoteTimeoutValue.setToolTipText(Messages.getString("GDBJtagDebuggerTab.remoteTimeoutTooltip"));
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).grab(true, false).create());
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.jtagDeviceLabel"));
        this.jtagDevice = new Combo(comp, 12);
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        Arrays.stream(availableDevices).map(GDBJtagDeviceContribution::getDeviceName).sorted().forEach(name -> this.jtagDevice.add(name));
        this.jtagDevice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.updateDeviceIpPort(GDBJtagDSFDebuggerTab.this.jtagDevice.getText());
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.remoteConnectionParameters = new Composite((Composite)group, 524296);
        this.remoteConnectParmsLayout = new StackLayout();
        this.remoteConnectionParameters.setLayout((Layout)this.remoteConnectParmsLayout);
        this.remoteConnectionParameters.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.remoteConnectionBox = new Composite(this.remoteConnectionParameters, 524296);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.remoteConnectionBox.setLayout((Layout)layout);
        this.remoteConnectionBox.setBackground(this.remoteConnectionParameters.getParent().getBackground());
        label = new Label(this.remoteConnectionBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.connectionLabel"));
        this.connection = new Text(this.remoteConnectionBox, 2048);
        gd = new GridData(768);
        this.connection.setLayoutData((Object)gd);
        this.connection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDSFDebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    protected void updateDeviceIpPort(String selectedDeviceName) {
        if (selectedDeviceName.equals(this.savedJtagDevice)) {
            return;
        }
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        IGDBJtagDevice selectedDevice = null;
        int i = 0;
        while (i < availableDevices.length) {
            String name = availableDevices[i].getDeviceName();
            if (name.equals(selectedDeviceName) && (selectedDevice = availableDevices[i].getDevice()) != null) {
                if (selectedDevice instanceof IGDBJtagConnection) {
                    IGDBJtagConnection connectionDevice = (IGDBJtagConnection)selectedDevice;
                    this.connection.setText(connectionDevice.getDefaultDeviceConnection());
                }
                this.useRemoteChanged();
                this.updateLaunchConfigurationDialog();
                break;
            }
            ++i;
        }
    }

    private void remoteTimeoutChanged() {
        this.remoteTimeoutValue.setEnabled(this.remoteTimeoutEnabled.getSelection());
    }

    private void useRemoteChanged() {
        boolean enabled = this.useRemote.getSelection();
        this.remoteTimeoutEnabled.setEnabled(enabled);
        this.remoteTimeoutValue.setEnabled(this.remoteTimeoutEnabled.getSelection());
        this.jtagDevice.setEnabled(enabled);
        this.connection.setEnabled(enabled);
        GDBJtagDeviceContribution selectedDeviceEntry = GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(this.jtagDevice.getText());
        if (selectedDeviceEntry == null || selectedDeviceEntry.getDevice() == null) {
            this.remoteConnectParmsLayout.topControl = null;
            this.remoteConnectionParameters.layout();
        } else {
            IGDBJtagDevice device = selectedDeviceEntry.getDevice();
            if (device instanceof IGDBJtagConnection) {
                this.remoteConnectParmsLayout.topControl = this.remoteConnectionBox;
                this.remoteConnectionBox.getParent().layout();
            } else {
                this.remoteConnectParmsLayout.topControl = null;
                this.remoteConnectionParameters.layout();
            }
        }
    }

    protected String getDeviceNameForDeviceId(String jtagDeviceId) {
        GDBJtagDeviceContribution contribution = GDBJtagDeviceContributionFactory.getInstance().findByDeviceId(jtagDeviceId);
        if (contribution != null) {
            return contribution.getDeviceName();
        }
        return "";
    }

    protected String getDeviceIdForDeviceName(String jtagDeviceName) {
        GDBJtagDeviceContribution device = GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(jtagDeviceName);
        if (device != null) {
            return device.getDeviceId();
        }
        return DEFAULT_JTAG_DEVICE_ID;
    }

    private GDBJtagDeviceContribution getDeviceContribution(ILaunchConfiguration configuration) throws CoreException {
        String deviceId = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", null);
        if (deviceId != null) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceId(deviceId);
        }
        String deviceName = configuration.getAttribute(ATTR_JTAG_DEVICE, null);
        if (deviceName != null) {
            return GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(deviceName);
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "", null);
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            this.gdbCommand.setText(gdbCommandAttr);
            boolean useRemoteAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
            this.useRemote.setSelection(useRemoteAttr);
            GDBJtagDeviceContribution savedDeviceContribution = this.getDeviceContribution(configuration);
            this.savedJtagDevice = savedDeviceContribution != null ? savedDeviceContribution.getDeviceName() : "";
            if (this.savedJtagDevice.isEmpty()) {
                String deviceName = this.getDeviceNameForDeviceId(DEFAULT_JTAG_DEVICE_ID);
                int index = 0;
                int i = 0;
                while (i < this.jtagDevice.getItemCount()) {
                    if (this.jtagDevice.getItem(i).equals(deviceName)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.jtagDevice.select(index);
            } else {
                String storedAddress = "";
                int storedPort = -1;
                String storedConnection = null;
                int i = 0;
                while (i < this.jtagDevice.getItemCount()) {
                    if (this.jtagDevice.getItem(i).equals(this.savedJtagDevice)) {
                        storedAddress = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "");
                        storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", -1);
                        storedConnection = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", null);
                        this.jtagDevice.select(i);
                        break;
                    }
                    ++i;
                }
                String connectionText = "unspecified-ip-address:unspecified-port-number";
                if (storedConnection != null) {
                    try {
                        connectionText = new URI(storedConnection).getSchemeSpecificPart();
                    }
                    catch (URISyntaxException e) {
                        Activator.log((Throwable)e);
                    }
                } else if (storedPort != -1) {
                    connectionText = String.format("%s:%d", storedAddress, storedPort);
                }
                this.connection.setText(connectionText);
            }
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
            this.remoteTimeoutEnabled.setSelection(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", LaunchUtils.getRemoteTimeoutEnabledDefault()));
            this.remoteTimeoutValue.setText(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", LaunchUtils.getRemoteTimeoutValueDefault()));
            this.remoteTimeoutChanged();
            this.useRemoteChanged();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdbCommand.getText().trim());
        this.savedJtagDevice = this.jtagDevice.getText();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", this.getDeviceIdForDeviceName(this.savedJtagDevice));
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", this.useRemote.getSelection());
        if (this.useRemote.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        } else {
            configuration.removeAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE");
        }
        if (!this.savedJtagDevice.isEmpty()) {
            try {
                IGDBJtagDevice device = GDBJtagDeviceContributionFactory.getInstance().findByDeviceName(this.savedJtagDevice).getDevice();
                if (device instanceof IGDBJtagConnection) {
                    String conn = this.connection.getText().trim();
                    URI uri = new URI("gdb", conn, "");
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", uri.toString());
                    configuration.removeAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress");
                    configuration.removeAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber");
                } else {
                    configuration.removeAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection");
                }
            }
            catch (URISyntaxException e) {
                Activator.log((Throwable)e);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_ENABLED", this.remoteTimeoutEnabled.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TIMEOUT_VALUE", this.remoteTimeoutValue.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "", null);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDeviceId", DEFAULT_JTAG_DEVICE_ID);
        configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

